(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2146062,      50663]
NotebookOptionsPosition[   2135995,      50524]
NotebookOutlinePosition[   2136429,      50541]
CellTagsIndexPosition[   2136386,      50538]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Plot data and fits", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 3.860139755017807*^9}, {
  3.9022202669447126`*^9, 
  3.9022202738303194`*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell["\<\
This notebook is used for plotting multiple samples in one figure.\
\>", "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 3.861942913146066*^9}, {
  3.9022202811863976`*^9, 
  3.902220291076703*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Import data (previously processed in a different notebook)", \
"Subsection",
 CellChangeTimes->{{3.902215546140896*^9, 3.902215554970817*^9}, {
  3.9022172423037977`*^9, 
  3.9022172450257316`*^9}},ExpressionUUID->"05ff968c-c2cd-4505-bd49-\
519a456dd620"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "C14", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C14 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC14", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC14", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C14 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC14", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC14", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC14NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C15", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C15 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC15", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC15", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C15 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC15", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC15", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC15NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C16", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C16 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC16", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC16", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C16 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC16", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC16", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC16NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C20", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C20 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC20", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC20", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C20 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC20", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC20", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC20NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C21", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C21 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC21", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC21", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C21 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC21", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC21", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC21NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C22", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C22 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC22", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC22", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C22 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC22", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC22", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC22NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Import", " ", "DLS", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC14", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-500g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC14", "=", 
     RowBox[{"dataDLSC14", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC14", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "here", " ", "we", " ", "used", " ", "R", " ", "instead", " ", "of", " ",
       "Dh"}], ";", " ", 
     RowBox[{"D", " ", "=", " ", 
      RowBox[{
       RowBox[{"4", "/", "3"}], " ", "Dh"}]}], ";", " ", 
     RowBox[{"R", " ", "=", " ", 
      RowBox[{
       RowBox[{"4", "/", "3"}], " ", 
       RowBox[{"Dh", "/", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC15", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-1000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC15", "=", 
     RowBox[{"dataDLSC15", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC15", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC16", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC16", "=", 
     RowBox[{"dataDLSC16", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC16", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-500g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", 
     RowBox[{"dataDLSC20", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC20", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC21", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-1000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC21", "=", 
     RowBox[{"dataDLSC21", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC21", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC22", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC22", "=", 
     RowBox[{"dataDLSC22", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC22", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9022149115519915`*^9, 3.902214928032826*^9}, {
   3.9022150167319202`*^9, 3.9022150644423866`*^9}, {3.902215095852667*^9, 
   3.9022152713751416`*^9}, {3.902215382750983*^9, 3.9022154164512854`*^9}, 
   3.902215533177294*^9, {3.902216229033347*^9, 3.902216235713913*^9}, {
   3.9022162659820976`*^9, 3.902216278847211*^9}, {3.9022164330284615`*^9, 
   3.9022164731633058`*^9}, {3.9022165155945787`*^9, 
   3.9022165618679824`*^9}, {3.9022166101726637`*^9, 3.902216666465963*^9}, {
   3.902216755747498*^9, 3.902216849924554*^9}, {3.9022175917249975`*^9, 
   3.9022176842847805`*^9}, {3.9022177317856274`*^9, 
   3.9022178257695775`*^9}, {3.902221859450025*^9, 3.9022219362276278`*^9}, {
   3.9023779753574314`*^9, 3.902378171173195*^9}, {3.9023856262031407`*^9, 
   3.9023856412986794`*^9}, {3.902386739539275*^9, 3.902386755955065*^9}, {
   3.904796370674417*^9, 3.904796383259288*^9}, {3.904796452679225*^9, 
   3.9047964757987194`*^9}, {3.904798242079618*^9, 3.904798284099079*^9}},
 CellLabel->
  "In[539]:=",ExpressionUUID->"b66525ca-dbd1-499c-86f2-a52ff36ff035"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"datamergedbinned", "\[IndentingNewLine]", "slopes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "datamergedbinnedC14", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"dataDLSC20", "=", 
     RowBox[{"dataDLSC20", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC20", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";", "\[IndentingNewLine]", "dataDLSC20"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9022176983981686`*^9, 3.9022177028977084`*^9}, 
   3.9022177413174353`*^9, {3.902378336480983*^9, 3.902378356433791*^9}, {
   3.902385510376478*^9, 3.9023855133622427`*^9}, {3.9023855833053727`*^9, 
   3.9023856207906637`*^9}, {3.902386677154141*^9, 3.902386684288723*^9}, {
   3.9023867296946726`*^9, 3.902386736491104*^9}},
 CellLabel->
  "In[1106]:=",ExpressionUUID->"9ae5eaff-e228-4d54-9852-b1ab8f5ef318"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot merged data and slopes", "Subsection",
 CellChangeTimes->{{3.9022171611679006`*^9, 
  3.9022171697188206`*^9}},ExpressionUUID->"31402af8-8d6f-4a29-9ffd-\
3acaa818d538"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Plot", " ", "merged", " ", "data", " ", "C14"}], "-", "C16"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "datamergedbinnedC14", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC15", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC16"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "4", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "3", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C14\>\"", ",", " ", "\"\<C15\>\"", ",", " ", "\"\<C16\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinnedC14-16.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "slopes", " ", "C14"}], "-", "C16"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"datamerged", ",", "0.15"}], "]"}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "slopesC14", ",", "\[IndentingNewLine]", "slopesC15", ",", 
        "\[IndentingNewLine]", "slopesC16"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C14\>\"", ",", " ", "\"\<C15\>\"", ",", " ", "\"\<C16\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<SlopesC14-16.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotSlopes", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "merged", " ", "data", " ", "C20"}], "-", "C22"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "datamergedbinnedC20", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC21", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC22"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "4", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "3", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C20\>\"", ",", " ", "\"\<C21\>\"", ",", " ", "\"\<C22\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinnedC20-22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "slopes", " ", "C20"}], "-", "C22"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"datamerged", ",", "0.15"}], "]"}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopesC22"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C20\>\"", ",", " ", "\"\<C21\>\"", ",", " ", "\"\<C22\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<SlopesC20-22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotSlopes", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.902217140297951*^9, 3.902217142443056*^9}, {
  3.9022172099071436`*^9, 3.902217219370745*^9}, {3.90221747755323*^9, 
  3.9022174854501867`*^9}, {3.90221783596463*^9, 3.902217844747697*^9}, {
  3.9022179432654448`*^9, 3.902218032003544*^9}, {3.9022180686460114`*^9, 
  3.9022180788450203`*^9}, {3.902218146414893*^9, 3.9022181956068068`*^9}, {
  3.902218258187581*^9, 3.902218298334155*^9}, {3.902220330818726*^9, 
  3.90222033766553*^9}, {3.9022219542091923`*^9, 3.902222037404671*^9}, {
  3.903580733279014*^9, 3.9035807377356052`*^9}, {3.9047950807536182`*^9, 
  3.9047951594294024`*^9}, {3.904795195194067*^9, 3.9047952008467627`*^9}, {
  3.9047955140511813`*^9, 3.904795523708535*^9}, {3.9047955691227865`*^9, 
  3.9047955975647383`*^9}, {3.9059260892610974`*^9, 3.905926110043765*^9}},
 CellLabel->
  "In[593]:=",ExpressionUUID->"a0e9289a-ab87-4bb3-a319-78f5d7640948"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.777881903329149, 
           6.878726819268058}, {-5.777881903329149, 6.9184577741757565`}}], 
          
          LineBox[{{-5.777881903329149, 
           6.9184577741757565`}, {-5.777881903329149, 
           6.956670316206544}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.483842181677217, 
           6.55349676658566}, {-5.483842181677217, 6.586144765484615}}], 
          
          LineBox[{{-5.483842181677217, 
           6.586144765484615}, {-5.483842181677217, 6.617760485600308}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.380228407219979, 
           6.390559679891012}, {-5.380228407219979, 6.417682506571226}}], 
          
          LineBox[{{-5.380228407219979, 
           6.417682506571226}, {-5.380228407219979, 6.44408906986336}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.286352047426554, 
           6.253732997777246}, {-5.286352047426554, 6.281073763888456}}], 
          
          LineBox[{{-5.286352047426554, 
           6.281073763888456}, {-5.286352047426554, 
           6.3076868633511465`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.228332740694611, 
           6.163791597071153}, {-5.228332740694611, 6.188399531059561}}], 
          
          LineBox[{{-5.228332740694611, 
           6.188399531059561}, {-5.228332740694611, 6.212416429684072}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           6.068923646345879}, {-5.1734965151745005`, 6.090711778917184}}], 
          
          LineBox[{{-5.1734965151745005`, 
           6.090711778917184}, {-5.1734965151745005`, 
           6.1120352939285265`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.121512103387059, 
           5.994727497639104}, {-5.121512103387059, 6.016042515009739}}], 
          
          LineBox[{{-5.121512103387059, 
           6.016042515009739}, {-5.121512103387059, 6.036912668211323}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           5.906701642237373}, {-5.0720974097604925`, 5.928649522509385}}], 
          
          LineBox[{{-5.0720974097604925`, 
           5.928649522509385}, {-5.0720974097604925`, 
           5.950126020655823}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.025010372042255, 
           5.847753870085171}, {-5.025010372042255, 5.863838576219642}}], 
          
          LineBox[{{-5.025010372042255, 
           5.863838576219642}, {-5.025010372042255, 5.879668654789482}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.980041374477484, 
           5.763055340446589}, {-4.980041374477484, 5.779985825108138}}], 
          
          LineBox[{{-4.980041374477484, 
           5.779985825108138}, {-4.980041374477484, 5.796634434129114}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.92662358321994, 5.656592950985593}, {-4.92662358321994,
            5.679655256926716}}], 
          
          LineBox[{{-4.92662358321994, 5.679655256926716}, {-4.92662358321994,
            5.702197660535848}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.87574337247038, 5.575163644103877}, {-4.87574337247038,
            5.59219970560415}}], 
          
          LineBox[{{-4.87574337247038, 5.59219970560415}, {-4.87574337247038, 
           5.608950394551151}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.827483513108963, 
           5.48781579400378}, {-4.827483513108963, 5.508425087484682}}], 
          
          LineBox[{{-4.827483513108963, 
           5.508425087484682}, {-4.827483513108963, 5.528618200735277}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.77239942676781, 5.394756481981338}, {-4.77239942676781,
            5.413829642084569}}], 
          
          LineBox[{{-4.77239942676781, 5.413829642084569}, {-4.77239942676781,
            5.432545815005675}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.720192452293243, 
           5.302321713051443}, {-4.720192452293243, 5.321422004089876}}], 
          
          LineBox[{{-4.720192452293243, 
           5.321422004089876}, {-4.720192452293243, 5.340164301120824}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.670576785004793, 
           5.206366892014528}, {-4.670576785004793, 5.22806972562423}}], 
          
          LineBox[{{-4.670576785004793, 
           5.22806972562423}, {-4.670576785004793, 5.249311534088339}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.623307322213241, 
           5.1321528854585985`}, {-4.623307322213241, 5.144809162357253}}], 
          
          LineBox[{{-4.623307322213241, 
           5.144809162357253}, {-4.623307322213241, 5.157307257814031}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.578172095309458, 
           5.034956657658233}, {-4.578172095309458, 5.050745719930849}}], 
          
          LineBox[{{-4.578172095309458, 
           5.050745719930849}, {-4.578172095309458, 
           5.0662893577192145`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.528024063416046, 
           4.940316626750307}, {-4.528024063416046, 4.960480112103796}}], 
          
          LineBox[{{-4.528024063416046, 
           4.960480112103796}, {-4.528024063416046, 4.980245054103072}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.473567500947851, 
           4.836012077293325}, {-4.473567500947851, 4.856216188230888}}], 
          
          LineBox[{{-4.473567500947851, 
           4.856216188230888}, {-4.473567500947851, 4.876020164101331}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           4.735906917638573}, {-4.4219245540939545`, 4.75258284764823}}], 
          
          LineBox[{{-4.4219245540939545`, 
           4.75258284764823}, {-4.4219245540939545`, 4.768985246173363}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.372818566555532, 
           4.649109389477674}, {-4.372818566555532, 4.661077861417712}}], 
          
          LineBox[{{-4.372818566555532, 
           4.661077861417712}, {-4.372818566555532, 4.672904781526578}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.326011954933506, 
           4.568223468833393}, {-4.326011954933506, 4.579271027116369}}], 
          
          LineBox[{{-4.326011954933506, 
           4.579271027116369}, {-4.326011954933506, 4.590197869259573}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.275892138786888, 
           4.459172766237821}, {-4.275892138786888, 4.473753546825009}}], 
          
          LineBox[{{-4.275892138786888, 
           4.473753546825009}, {-4.275892138786888, 
           4.4881247799560695`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.222951251037713, 
           4.356473190392281}, {-4.222951251037713, 4.370603872879289}}], 
          
          LineBox[{{-4.222951251037713, 
           4.370603872879289}, {-4.222951251037713, 4.384537658238916}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.172673294218139, 
           4.252815111277387}, {-4.172673294218139, 4.269781901190199}}], 
          
          LineBox[{{-4.172673294218139, 
           4.269781901190199}, {-4.172673294218139, 4.28646561535245}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.124803134014643, 
           4.165395026734142}, {-4.124803134014643, 4.174359610739594}}], 
          
          LineBox[{{-4.124803134014643, 
           4.174359610739594}, {-4.124803134014643, 4.183244544481459}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.074701219535939, 
           4.057479293653429}, {-4.074701219535939, 4.07226928010167}}], 
          
          LineBox[{{-4.074701219535939, 
           4.07226928010167}, {-4.074701219535939, 4.086843707100068}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.026921534839552, 
           3.9654573128093507`}, {-4.026921534839552, 3.9768165361449364`}}], 
          
          LineBox[{{-4.026921534839552, 
           3.9768165361449364`}, {-4.026921534839552, 
           3.9880481754250634`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           3.867201239847278}, {-3.9773780413268547`, 3.8796132558421497`}}], 
          
          LineBox[{{-3.9773780413268547`, 
           3.8796132558421497`}, {-3.9773780413268547`, 
           3.8918731005191587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           3.7700880851945224`}, {-3.9262371908045295`, 3.787144426066366}}], 
          
          LineBox[{{-3.9262371908045295`, 
           3.787144426066366}, {-3.9262371908045295`, 
           3.803914720265529}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           3.665785130814023}, {-3.8776461425773476`, 3.6764286553000516`}}], 
          
          LineBox[{{-3.8776461425773476`, 
           3.6764286553000516`}, {-3.8776461425773476`, 
           3.686960087185884}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.827799486652153, 
           3.544783979948073}, {-3.827799486652153, 3.5601804033253246`}}], 
          
          LineBox[{{-3.827799486652153, 
           3.5601804033253246`}, {-3.827799486652153, 
           3.575343366756121}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           3.4464844760408786`}, {-3.7770410262852683`, 
           3.4563673283855905`}}], 
          
          LineBox[{{-3.7770410262852683`, 
           3.4563673283855905`}, {-3.7770410262852683`, 
           3.466153465007558}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7255676492705025`, 
           3.333768178046292}, {-3.7255676492705025`, 3.34452137650881}}], 
          
          LineBox[{{-3.7255676492705025`, 
           3.34452137650881}, {-3.7255676492705025`, 
           3.3551601727928455`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           3.2445125507473445`}, {-3.6766150586043187`, 
           3.2567095153320316`}}], 
          
          LineBox[{{-3.6766150586043187`, 
           3.2567095153320316`}, {-3.6766150586043187`, 
           3.2687595048215643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           3.1365924522624624`}, {-3.6271250750319357`, 3.147662858557783}}], 
          
          LineBox[{{-3.6271250750319357`, 
           3.147662858557783}, {-3.6271250750319357`, 
           3.1586120516130087`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.577239779380398, 
           3.0325212574274714`}, {-3.577239779380398, 3.042410579884443}}], 
          
          LineBox[{{-3.577239779380398, 
           3.042410579884443}, {-3.577239779380398, 
           3.0522030605608346`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           2.923669587441966}, {-3.5271719803333474`, 2.933922856972525}}], 
          
          LineBox[{{-3.5271719803333474`, 
           2.933922856972525}, {-3.5271719803333474`, 
           2.944072063055176}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           2.8194606743388992`}, {-3.4770227859145613`, 
           2.8289695028440063`}}], 
          
          LineBox[{{-3.4770227859145613`, 
           2.8289695028440063`}, {-3.4770227859145613`, 
           2.838388764536525}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           2.716416966054618}, {-3.4269594457071775`, 2.7281019574944008`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           2.7281019574944008`}, {-3.4269594457071775`, 
           2.7396519854386248`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.377049578478242, 
           2.6071234635756237`}, {-3.377049578478242, 2.6180705560226616`}}], 
          
          LineBox[{{-3.377049578478242, 
           2.6180705560226616`}, {-3.377049578478242, 
           2.6288991061592815`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.327422124402821, 
           2.5014938567729668`}, {-3.327422124402821, 2.51011455089501}}], 
          
          LineBox[{{-3.327422124402821, 
           2.51011455089501}, {-3.327422124402821, 2.518661563384314}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           2.4008059109208832`}, {-3.2761327623308096`, 2.411568215254365}}], 
          
          LineBox[{{-3.2761327623308096`, 
           2.411568215254365}, {-3.2761327623308096`, 
           2.4222159246050428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           2.287624433961096}, {-3.2254264836890396`, 2.2973063093590156`}}], 
          
          LineBox[{{-3.2254264836890396`, 
           2.2973063093590156`}, {-3.2254264836890396`, 
           2.306895344198164}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.17716826024446, 2.19094782690196}, {-3.17716826024446, 
           2.1993048372384356`}}], 
          
          LineBox[{{-3.17716826024446, 
           2.1993048372384356`}, {-3.17716826024446, 
           2.2075925863699966`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.127705210497175, 
           2.078092959715192}, {-3.127705210497175, 2.089174565489172}}], 
          
          LineBox[{{-3.127705210497175, 
           2.089174565489172}, {-3.127705210497175, 
           2.1001347139889504`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.077261733718196, 
           1.9708729324895589`}, {-3.077261733718196, 1.9792310272765963`}}], 
          
          LineBox[{{-3.077261733718196, 
           1.9792310272765963`}, {-3.077261733718196, 
           1.9875198429565457`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           1.8572364829597598`}, {-3.0276924518494375`, 
           1.8651504515910073`}}], 
          
          LineBox[{{-3.0276924518494375`, 
           1.8651504515910073`}, {-3.0276924518494375`, 
           1.8730022807706561`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.977298040136891, 
           1.7506029913817016`}, {-2.977298040136891, 1.7597751076397197`}}], 
          
          LineBox[{{-2.977298040136891, 
           1.7597751076397197`}, {-2.977298040136891, 
           1.7688638602232825`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.932588839908245, 
           1.6564890917128041`}, {-2.932588839908245, 1.665051362096523}}], 
          
          LineBox[{{-2.932588839908245, 
           1.665051362096523}, {-2.932588839908245, 1.673540941961671}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.522480231534296, 
           0.720604967582006}, {-2.522480231534296, 0.7656995770952001}}], 
          
          LineBox[{{-2.522480231534296, 
           0.7656995770952001}, {-2.522480231534296, 
           0.8088481050675193}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.380038563220422, 
           0.39879323899974956`}, {-2.380038563220422, 0.4390889490370415}}], 
          
          LineBox[{{-2.380038563220422, 
           0.4390889490370415}, {-2.380038563220422, 
           0.4778236151701993}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.2851211182798545`, 
           0.17272969664193336`}, {-2.2851211182798545`, 
           0.20965334557164986`}}], 
          
          LineBox[{{-2.2851211182798545`, 
           0.20965334557164986`}, {-2.2851211182798545`, 
           0.2452620472369691}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.226506167649257, 
           0.036077237182485754`}, {-2.226506167649257, 
           0.07052855485839256}}], 
          
          LineBox[{{-2.226506167649257, 
           0.07052855485839256}, {-2.226506167649257, 
           0.10383240142889456`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1711381157832257`, -0.09835029616405125}, \
{-2.1711381157832257`, -0.06435250941459827}}], 
          
          LineBox[{{-2.1711381157832257`, -0.06435250941459827}, \
{-2.1711381157832257`, -0.03147266861571993}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1186760185140363`, -0.2265330666634384}, \
{-2.1186760185140363`, -0.19366503800277377`}}], 
          
          LineBox[{{-2.1186760185140363`, -0.19366503800277377`}, \
{-2.1186760185140363`, -0.16184302726966732`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.0688299492905053`, -0.3512222145420803}, \
{-2.0688299492905053`, -0.3202012539463972}}], 
          
          LineBox[{{-2.0688299492905053`, -0.3202012539463972}, \
{-2.0688299492905053`, -0.29011371044856843`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.021351319690928, -0.4683116373812356}, \
{-2.021351319690928, -0.43900658034861145`}}], 
          
          LineBox[{{-2.021351319690928, -0.43900658034861145`}, \
{-2.021351319690928, -0.41053591577615045`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.976025406568619, -0.5821393959075106}, \
{-1.976025406568619, -0.5540323913504438}}], 
          
          LineBox[{{-1.976025406568619, -0.5540323913504438}, \
{-1.976025406568619, -0.526693840764367}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.9326653384575119`, -0.690056439133567}, \
{-1.9326653384575119`, -0.6627740047087505}}], 
          
          LineBox[{{-1.9326653384575119`, -0.6627740047087505}, \
{-1.9326653384575119`, -0.636216176247646}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8810672419769725`, -0.8259161606537296}, \
{-1.8810672419769725`, -0.7954179270188315}}], 
          
          LineBox[{{-1.8810672419769725`, -0.7954179270188315}, \
{-1.8810672419769725`, -0.7658223733875608}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8223707416388202`, -0.9788893713770673}, \
{-1.8223707416388202`, -0.9491629922191582}}], 
          
          LineBox[{{-1.8223707416388202`, -0.9491629922191582}, \
{-1.8223707416388202`, -0.9202948206447312}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7758907745205157`, -1.0983526372476962`}, \
{-1.7758907745205157`, -1.0740330078300782`}}], 
          
          LineBox[{{-1.7758907745205157`, -1.0740330078300782`}, \
{-1.7758907745205157`, -1.0502908077043205`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7316070609965282`, -1.2208753155952436`}, \
{-1.7316070609965282`, -1.1928738536970798`}}], 
          
          LineBox[{{-1.7316070609965282`, -1.1928738536970798`}, \
{-1.7316070609965282`, -1.1656351634267907`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.680857774871063, -1.3574115343233186`}, \
{-1.680857774871063, -1.3314510690829922`}}], 
          
          LineBox[{{-1.680857774871063, -1.3314510690829922`}, \
{-1.680857774871063, -1.3061475314124875`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.632560487956873, -1.4909633613263018`}, \
{-1.632560487956873, -1.4653508542608025`}}], 
          
          LineBox[{{-1.632560487956873, -1.4653508542608025`}, \
{-1.632560487956873, -1.4403779987273646`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5790774413137347`, -1.64356276485336}, \
{-1.5790774413137347`, -1.6161503653993559`}}], 
          
          LineBox[{{-1.5790774413137347`, -1.6161503653993559`}, \
{-1.5790774413137347`, -1.5894693998105025`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5281875999704038`, -1.7852190095467984`}, \
{-1.5281875999704038`, -1.7607599166447272`}}], 
          
          LineBox[{{-1.5281875999704038`, -1.7607599166447272`}, \
{-1.5281875999704038`, -1.7368848154784444`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4798745637368198`, -1.9269494331280526`}, \
{-1.4798745637368198`, -1.9015118745260273`}}], 
          
          LineBox[{{-1.4798745637368198`, -1.9015118745260273`}, \
{-1.4798745637368198`, -1.8767053661179152`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4273150021222818`, -2.082211703888827}, \
{-1.4273150021222818`, -2.0569913541136855`}}], 
          
          LineBox[{{-1.4273150021222818`, -2.0569913541136855`}, \
{-1.4273150021222818`, -2.032391454488731}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.377381030775886, -2.2298354303326553`}, \
{-1.377381030775886, -2.2063649221245973`}}], 
          
          LineBox[{{-1.377381030775886, -2.2063649221245973`}, \
{-1.377381030775886, -2.1834326696773707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.329822772449285, -2.373372950624341}, \
{-1.329822772449285, -2.350572671960546}}], 
          
          LineBox[{{-1.329822772449285, -2.350572671960546}, \
{-1.329822772449285, -2.3282806784879257`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2789374525299622`, -2.53087880297484}, \
{-1.2789374525299622`, -2.5062271583177056`}}], 
          
          LineBox[{{-1.2789374525299622`, -2.5062271583177056`}, \
{-1.2789374525299622`, -2.482168625378371}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2252283792125176`, -2.6995894833957337`}, \
{-1.2252283792125176`, -2.6759005149006745`}}], 
          
          LineBox[{{-1.2252283792125176`, -2.6759005149006745`}, \
{-1.2252283792125176`, -2.652759752245413}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.1742581157840541`, -2.8598353774055916`}, \
{-1.1742581157840541`, -2.837518507528072}}], 
          
          LineBox[{{-1.1742581157840541`, -2.837518507528072}, \
{-1.1742581157840541`, -2.815688827556169}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.125760810882863, -3.0159516481391178`}, \
{-1.125760810882863, -2.993870605717295}}], 
          
          LineBox[{{-1.125760810882863, -2.993870605717295}, \
{-1.125760810882863, -2.9722666207677366`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.0750347908756233`, -3.1849109666017066`}, \
{-1.0750347908756233`, -3.161769448836232}}], 
          
          LineBox[{{-1.0750347908756233`, -3.161769448836232}, \
{-1.0750347908756233`, -3.1391513705617813`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.026687762897248, -3.340570739164708}, \
{-1.026687762897248, -3.3200346993578633`}}], 
          
          LineBox[{{-1.026687762897248, -3.3200346993578633`}, \
{-1.026687762897248, -3.2999119160607924`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9806356434778151, -3.4971060998997263`}, \
{-0.9806356434778151, -3.475541079865531}}], 
          
          LineBox[{{-0.9806356434778151, -3.475541079865531}, \
{-0.9806356434778151, -3.454431309717485}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9288080748978164, -3.6732946373166486`}, \
{-0.9288080748978164, -3.6512842589010117`}}], 
          
          LineBox[{{-0.9288080748978164, -3.6512842589010117`}, \
{-0.9288080748978164, -3.6297479221324442`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8758086169295246, -3.8523665070471513`}, \
{-0.8758086169295246, -3.831381295291119}}], 
          
          LineBox[{{-0.8758086169295246, -3.831381295291119}, \
{-0.8758086169295246, -3.810827426331437}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8254778772492771, -4.0214234639200805`}, \
{-0.8254778772492771, -4.001549931982177}}], 
          
          LineBox[{{-0.8254778772492771, -4.001549931982177}, \
{-0.8254778772492771, -3.9820636733257686`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7775597923865766, -4.184214709978015}, \
{-0.7775597923865766, -4.165503148825294}}], 
          
          LineBox[{{-0.7775597923865766, -4.165503148825294}, \
{-0.7775597923865766, -4.147135288851474}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7286714703974044, -4.353601292670439}, \
{-0.7286714703974044, -4.3344836855565845`}}], 
          
          LineBox[{{-0.7286714703974044, -4.3344836855565845`}, \
{-0.7286714703974044, -4.315724715774761}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.483842181677217, 
           5.417837514274544}, {-5.483842181677217, 5.464425104439405}}], 
          
          LineBox[{{-5.483842181677217, 
           5.464425104439405}, {-5.483842181677217, 5.508938561506401}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.380228407219979, 
           5.3225930518109035`}, {-5.380228407219979, 5.333630880724602}}], 
          
          LineBox[{{-5.380228407219979, 
           5.333630880724602}, {-5.380228407219979, 5.344548204872068}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.286352047426554, 
           5.206400183548847}, {-5.286352047426554, 5.219882294260513}}], 
          
          LineBox[{{-5.286352047426554, 
           5.219882294260513}, {-5.286352047426554, 5.233185053025214}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.228332740694611, 
           5.176319154330323}, {-5.228332740694611, 5.184592115885053}}], 
          
          LineBox[{{-5.228332740694611, 
           5.184592115885053}, {-5.228332740694611, 5.192797196737359}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           5.110132688625956}, {-5.1734965151745005`, 5.137053569635874}}], 
          
          LineBox[{{-5.1734965151745005`, 
           5.137053569635874}, {-5.1734965151745005`, 5.16326867539695}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.121512103387059, 
           5.046460606160277}, {-5.121512103387059, 5.063617291563528}}], 
          
          LineBox[{{-5.121512103387059, 
           5.063617291563528}, {-5.121512103387059, 
           5.0804845831722485`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           4.959181185941672}, {-5.0720974097604925`, 4.976886806119893}}], 
          
          LineBox[{{-5.0720974097604925`, 
           4.976886806119893}, {-5.0720974097604925`, 
           4.994284383493903}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.025010372042255, 
           4.877619299771134}, {-5.025010372042255, 4.891975729411344}}], 
          
          LineBox[{{-5.025010372042255, 
           4.891975729411344}, {-5.025010372042255, 4.906128965670482}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.980041374477484, 
           4.786700683245617}, {-4.980041374477484, 4.814503845152611}}], 
          
          LineBox[{{-4.980041374477484, 
           4.814503845152611}, {-4.980041374477484, 4.841554856278032}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.92662358321994, 4.715462383418227}, {-4.92662358321994,
            4.737819366249398}}], 
          
          LineBox[{{-4.92662358321994, 4.737819366249398}, {-4.92662358321994,
            4.759687425339699}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.87574337247038, 4.630913774365157}, {-4.87574337247038,
            4.653976487107258}}], 
          
          LineBox[{{-4.87574337247038, 4.653976487107258}, {-4.87574337247038,
            4.676519279381845}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.827483513108963, 
           4.5000768159234275`}, {-4.827483513108963, 4.537692654679549}}], 
          
          LineBox[{{-4.827483513108963, 
           4.537692654679549}, {-4.827483513108963, 4.573944687833027}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.77239942676781, 4.449335571203944}, {-4.77239942676781,
            4.4695674831794925`}}], 
          
          LineBox[{{-4.77239942676781, 
           4.4695674831794925`}, {-4.77239942676781, 4.48939816904962}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.720192452293243, 
           4.352695960160602}, {-4.720192452293243, 4.368286715931976}}], 
          
          LineBox[{{-4.720192452293243, 
           4.368286715931976}, {-4.720192452293243, 4.38363812683159}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.670576785004793, 
           4.23722347043888}, {-4.670576785004793, 4.256989991356286}}], 
          
          LineBox[{{-4.670576785004793, 
           4.256989991356286}, {-4.670576785004793, 4.276373358312023}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.623307322213241, 
           4.170494438096535}, {-4.623307322213241, 4.190556355312096}}], 
          
          LineBox[{{-4.623307322213241, 
           4.190556355312096}, {-4.623307322213241, 
           4.2102236950131235`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.578172095309458, 
           4.093944785141605}, {-4.578172095309458, 4.11358571000768}}], 
          
          LineBox[{{-4.578172095309458, 
           4.11358571000768}, {-4.578172095309458, 4.13284828809653}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.528024063416046, 
           3.991961225242301}, {-4.528024063416046, 4.015987305113403}}], 
          
          LineBox[{{-4.528024063416046, 
           4.015987305113403}, {-4.528024063416046, 4.039449650323451}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.473567500947851, 
           3.8960611887669825`}, {-4.473567500947851, 3.9181807203033525`}}], 
          
          LineBox[{{-4.473567500947851, 
           3.9181807203033525`}, {-4.473567500947851, 
           3.9398215477786636`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           3.8228570574236875`}, {-4.4219245540939545`, 3.839083039583799}}], 
          
          LineBox[{{-4.4219245540939545`, 
           3.839083039583799}, {-4.4219245540939545`, 
           3.8550499375488516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.372818566555532, 
           3.7244599448592295`}, {-4.372818566555532, 3.740220787357705}}], 
          
          LineBox[{{-4.372818566555532, 
           3.740220787357705}, {-4.372818566555532, 3.755737075105077}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.326011954933506, 
           3.642353947140639}, {-4.326011954933506, 3.6531535519137917`}}], 
          
          LineBox[{{-4.326011954933506, 
           3.6531535519137917`}, {-4.326011954933506, 
           3.6638377702422016`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.275892138786888, 
           3.541522917327234}, {-4.275892138786888, 3.554734859295386}}], 
          
          LineBox[{{-4.275892138786888, 
           3.554734859295386}, {-4.275892138786888, 
           3.5677745195555377`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.222951251037713, 
           3.463020220355893}, {-4.222951251037713, 3.4746322834901897`}}], 
          
          LineBox[{{-4.222951251037713, 
           3.4746322834901897`}, {-4.222951251037713, 
           3.4861110529482615`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.172673294218139, 
           3.3625658738797313`}, {-4.172673294218139, 3.3721568093433505`}}], 
          
          LineBox[{{-4.172673294218139, 
           3.3721568093433505`}, {-4.172673294218139, 
           3.3816566319298387`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.124803134014643, 
           3.2435448320260485`}, {-4.124803134014643, 3.2643138037145327`}}], 
          
          LineBox[{{-4.124803134014643, 
           3.2643138037145327`}, {-4.124803134014643, 
           3.284660187062398}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.074701219535939, 
           3.158216940703002}, {-4.074701219535939, 3.166981562982009}}], 
          
          LineBox[{{-4.074701219535939, 
           3.166981562982009}, {-4.074701219535939, 
           3.1756700336144883`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.026921534839552, 
           3.0486649540172106`}, {-4.026921534839552, 3.0649675042920754`}}], 
          
          LineBox[{{-4.026921534839552, 
           3.0649675042920754`}, {-4.026921534839552, 
           3.081008539091662}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           2.9710960394935824`}, {-3.9773780413268547`, 2.987510993021455}}], 
          
          LineBox[{{-3.9773780413268547`, 
           2.987510993021455}, {-3.9773780413268547`, 
           3.0036608416776454`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           2.8546951380761514`}, {-3.9262371908045295`, 
           2.8691575089271093`}}], 
          
          LineBox[{{-3.9262371908045295`, 
           2.8691575089271093`}, {-3.9262371908045295`, 
           2.883413697943115}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           2.7685940148375114`}, {-3.8776461425773476`, 2.783931135735293}}], 
          
          LineBox[{{-3.8776461425773476`, 
           2.783931135735293}, {-3.8776461425773476`, 
           2.799036578163567}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.827799486652153, 
           2.6626022260682256`}, {-3.827799486652153, 2.6772943789938246`}}], 
          
          LineBox[{{-3.827799486652153, 
           2.6772943789938246`}, {-3.827799486652153, 
           2.691773794363211}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           2.534232817714081}, {-3.7770410262852683`, 2.541536060877438}}], 
          
          LineBox[{{-3.7770410262852683`, 
           2.541536060877438}, {-3.7770410262852683`, 
           2.548786353159605}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          LineBox[{{-3.7255676492705025`, 
           2.4155372235346264`}, {-3.7255676492705025`, 
           2.4317636809870544`}}], 
          
          LineBox[{{-3.7255676492705025`, 
           2.4317636809870544`}, {-3.7255676492705025`, 
           2.4477310391868503`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           2.3141683223556906`}, {-3.6766150586043187`, 
           2.3268988240712045`}}], 
          
          LineBox[{{-3.6766150586043187`, 
           2.3268988240712045`}, {-3.6766150586043187`, 
           2.3394692952477385`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           2.2026825144064497`}, {-3.6271250750319357`, 
           2.2114826220324577`}}], 
          
          LineBox[{{-3.6271250750319357`, 
           2.2114826220324577`}, {-3.6271250750319357`, 
           2.220205962829503}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.577239779380398, 
           2.138351611837451}, {-3.577239779380398, 2.1497141483636133`}}], 
          
          LineBox[{{-3.577239779380398, 
           2.1497141483636133`}, {-3.577239779380398, 
           2.1609490268149796`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           2.022387310492095}, {-3.5271719803333474`, 2.0319065570228574`}}], 
          
          LineBox[{{-3.5271719803333474`, 
           2.0319065570228574`}, {-3.5271719803333474`, 
           2.0413360412967285`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           1.9071914228403979`}, {-3.4770227859145613`, 
           1.9199765243853684`}}], 
          
          LineBox[{{-3.4770227859145613`, 
           1.9199765243853684`}, {-3.4770227859145613`, 
           1.9326002284216452`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           1.80580904315492}, {-3.4269594457071775`, 1.8161269829780138`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           1.8161269829780138`}, {-3.4269594457071775`, 
           1.8263395492317758`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.377049578478242, 
           1.6982468217302742`}, {-3.377049578478242, 1.7118291870599704`}}], 
          
          LineBox[{{-3.377049578478242, 
           1.7118291870599704`}, {-3.377049578478242, 
           1.7252295411246055`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.327422124402821, 
           1.588807928802749}, {-3.327422124402821, 1.6019626233883113`}}], 
          
          LineBox[{{-3.327422124402821, 
           1.6019626233883113`}, {-3.327422124402821, 
           1.6149465163957857`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           1.508819876909052}, {-3.2761327623308096`, 1.5156779530897848`}}], 
          
          LineBox[{{-3.2761327623308096`, 
           1.5156779530897848`}, {-3.2761327623308096`, 
           1.5224893162412891`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           1.374259465336078}, {-3.2254264836890396`, 1.3879756042382896`}}], 
          
          LineBox[{{-3.2254264836890396`, 
           1.3879756042382896`}, {-3.2254264836890396`, 
           1.4015061533788404`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.17716826024446, 
           1.2839962928198143`}, {-3.17716826024446, 1.293378448134219}}], 
          
          LineBox[{{-3.17716826024446, 1.293378448134219}, {-3.17716826024446,
            1.3026733961687724`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.127705210497175, 
           1.185281368634678}, {-3.127705210497175, 1.1978363311896516`}}], 
          
          LineBox[{{-3.127705210497175, 
           1.1978363311896516`}, {-3.127705210497175, 
           1.2102356191293275`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.077261733718196, 
           1.0767785214228451`}, {-3.077261733718196, 1.0867374837788857`}}], 
          
          LineBox[{{-3.077261733718196, 
           1.0867374837788857`}, {-3.077261733718196, 
           1.0965982424072902`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           0.9729319658086968}, {-3.0276924518494375`, 0.9850537525105203}}], 
          
          LineBox[{{-3.0276924518494375`, 
           0.9850537525105203}, {-3.0276924518494375`, 
           0.997030359579647}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.977298040136891, 
           0.8562551208123013}, {-2.977298040136891, 0.8683465073199272}}], 
          
          LineBox[{{-2.977298040136891, 
           0.8683465073199272}, {-2.977298040136891, 
           0.8802934371425442}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.932588839908245, 
           0.7611259976512463}, {-2.932588839908245, 0.7694025329536415}}], 
          
          LineBox[{{-2.932588839908245, 
           0.7694025329536415}, {-2.932588839908245, 
           0.7776111291353157}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.522480231534296, -0.13413734489922288`}, \
{-2.522480231534296, -0.09076332003771556}}], 
          
          LineBox[{{-2.522480231534296, -0.09076332003771556}, \
{-2.522480231534296, -0.04919265325399851}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.380038563220422, -0.4467421447418757}, \
{-2.380038563220422, -0.4078317670824148}}], 
          
          LineBox[{{-2.380038563220422, -0.4078317670824148}, \
{-2.380038563220422, -0.3703788726758086}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.2851211182798545`, -0.6621158919413321}, \
{-2.2851211182798545`, -0.6274646867398472}}], 
          
          LineBox[{{-2.2851211182798545`, -0.6274646867398472}, \
{-2.2851211182798545`, -0.5939740835347245}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.226506167649257, -0.7950549331318056}, \
{-2.226506167649257, -0.7616916242351741}}], 
          
          LineBox[{{-2.226506167649257, -0.7616916242351741}, \
{-2.226506167649257, -0.729405581258037}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1711381157832257`, -0.9224118791351459}, \
{-2.1711381157832257`, -0.8901233009952789}}], 
          
          LineBox[{{-2.1711381157832257`, -0.8901233009952789}, \
{-2.1711381157832257`, -0.8588447478634074}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1186760185140363`, -1.046272347457581}, \
{-2.1186760185140363`, -1.0142652637280023`}}], 
          
          LineBox[{{-2.1186760185140363`, -1.0142652637280023`}, \
{-2.1186760185140363`, -0.9832509401695667}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0688299492905053`, -1.1636489299954833`}, \
{-2.0688299492905053`, -1.1343184641208914`}}], 
          
          LineBox[{{-2.0688299492905053`, -1.1343184641208914`}, \
{-2.0688299492905053`, -1.105823817710152}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.021351319690928, -1.2750086650219452`}, \
{-2.021351319690928, -1.246794574841844}}], 
          
          LineBox[{{-2.021351319690928, -1.246794574841844}, \
{-2.021351319690928, -1.219354725008327}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.976025406568619, -1.3819327176281513`}, \
{-1.976025406568619, -1.3554601062395841`}}], 
          
          LineBox[{{-1.976025406568619, -1.3554601062395841`}, \
{-1.976025406568619, -1.3296702583164817`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.9326653384575119`, -1.4841290625854302`}, \
{-1.9326653384575119`, -1.4578141772959292`}}], 
          
          LineBox[{{-1.9326653384575119`, -1.4578141772959292`}, \
{-1.9326653384575119`, -1.432174047030941}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8810672419769725`, -1.6123365397642875`}, \
{-1.8810672419769725`, -1.5835618345718234`}}], 
          
          LineBox[{{-1.8810672419769725`, -1.5835618345718234`}, \
{-1.8810672419769725`, -1.5555920069046263`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8223707416388202`, -1.75597188625365}, \
{-1.8223707416388202`, -1.7282825872153513`}}], 
          
          LineBox[{{-1.8223707416388202`, -1.7282825872153513`}, \
{-1.8223707416388202`, -1.7013393732674091`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.7758907745205157`, -1.8683524999423151`}, \
{-1.7758907745205157`, -1.8452209669377861`}}], 
          
          LineBox[{{-1.7758907745205157`, -1.8452209669377861`}, \
{-1.7758907745205157`, -1.8226124269148638`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.7316070609965282`, -1.9813116473451888`}, \
{-1.7316070609965282`, -1.9555608991960096`}}], 
          
          LineBox[{{-1.7316070609965282`, -1.9555608991960096`}, \
{-1.7316070609965282`, -1.9304566393456335`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.680857774871063, -2.109714978568611}, \
{-1.680857774871063, -2.084853691113118}}], 
          
          LineBox[{{-1.680857774871063, -2.084853691113118}, \
{-1.680857774871063, -2.06059552325229}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.632560487956873, -2.231357849525613}, \
{-1.632560487956873, -2.207643969125207}}], 
          
          LineBox[{{-1.632560487956873, -2.207643969125207}, \
{-1.632560487956873, -2.184479434866337}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5790774413137347`, -2.374220223675227}, \
{-1.5790774413137347`, -2.3487857021387883`}}], 
          
          LineBox[{{-1.5790774413137347`, -2.3487857021387883`}, \
{-1.5790774413137347`, -2.3239820819803727`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5281875999704038`, -2.504139578060469}, \
{-1.5281875999704038`, -2.483030853564537}}], 
          
          LineBox[{{-1.5281875999704038`, -2.483030853564537}, \
{-1.5281875999704038`, -2.4623585117058133`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4798745637368198`, -2.6364093686589083`}, \
{-1.4798745637368198`, -2.612812183844095}}], 
          
          LineBox[{{-1.4798745637368198`, -2.612812183844095}, \
{-1.4798745637368198`, -2.589759013608759}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4273150021222818`, -2.7770452296855144`}, \
{-1.4273150021222818`, -2.753986856046442}}], 
          
          LineBox[{{-1.4273150021222818`, -2.753986856046442}, \
{-1.4273150021222818`, -2.7314482094500323`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.377381030775886, -2.9114797730071222`}, \
{-1.377381030775886, -2.8895155519621367`}}], 
          
          LineBox[{{-1.377381030775886, -2.8895155519621367`}, \
{-1.377381030775886, -2.868023407694775}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.329822772449285, -3.0435512808981082`}, \
{-1.329822772449285, -3.0222439174980185`}}], 
          
          LineBox[{{-1.329822772449285, -3.0222439174980185`}, \
{-1.329822772449285, -3.001381102153626}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2789374525299622`, -3.188598468348998}, \
{-1.2789374525299622`, -3.1657500104431104`}}], 
          
          LineBox[{{-1.2789374525299622`, -3.1657500104431104`}, \
{-1.2789374525299622`, -3.143411964156037}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2252283792125176`, -3.3406566640892486`}, \
{-1.2252283792125176`, -3.319232093082962}}], 
          
          LineBox[{{-1.2252283792125176`, -3.319232093082962}, \
{-1.2252283792125176`, -3.2982569229281125`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1742581157840541`, -3.48732431828529}, \
{-1.1742581157840541`, -3.4672107545015907`}}], 
          
          LineBox[{{-1.1742581157840541`, -3.4672107545015907`}, \
{-1.1742581157840541`, -3.4474937824002603`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.125760810882863, -3.6256515647545937`}, \
{-1.125760810882863, -3.606348565790899}}], 
          
          LineBox[{{-1.125760810882863, -3.606348565790899}, \
{-1.125760810882863, -3.5874111273180835`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0750347908756233`, -3.7788249036850137`}, \
{-1.0750347908756233`, -3.757787844084705}}], 
          
          LineBox[{{-1.0750347908756233`, -3.757787844084705}, \
{-1.0750347908756233`, -3.7371842394001518`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.026687762897248, -3.9237496337754716`}, \
{-1.026687762897248, -3.9045557583567705`}}], 
          
          LineBox[{{-1.026687762897248, -3.9045557583567705`}, \
{-1.026687762897248, -3.885723360524215}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9765855081311018, -4.072672889894351}, \
{-0.9765855081311018, -4.053386555977001}}], 
          
          LineBox[{{-0.9765855081311018, -4.053386555977001}, \
{-0.9765855081311018, -4.034465157565224}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.084348085637381, 
           4.021390253745636}, {-5.084348085637381, 4.056479731190099}}], 
          
          LineBox[{{-5.084348085637381, 
           4.056479731190099}, {-5.084348085637381, 4.090379563320364}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.025010372042255, 
           3.8823717522216015`}, {-5.025010372042255, 3.9323977517516573`}}], 
          
          LineBox[{{-5.025010372042255, 
           3.9323977517516573`}, {-5.025010372042255, 
           3.9800399302812686`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.980041374477484, 
           3.874261114639935}, {-4.980041374477484, 3.885479136336902}}], 
          
          LineBox[{{-4.980041374477484, 
           3.885479136336902}, {-4.980041374477484, 
           3.8965727088065942`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.937008119887209, 
           3.8081324083798918`}, {-4.937008119887209, 3.839086851237379}}], 
          
          LineBox[{{-4.937008119887209, 
           3.839086851237379}, {-4.937008119887209, 3.869111816052016}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.885780418275388, 
           3.7228174482619396`}, {-4.885780418275388, 3.743820335327719}}], 
          
          LineBox[{{-4.885780418275388, 
           3.743820335327719}, {-4.885780418275388, 
           3.7643911601277855`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.836890997791754, 
           3.62724602553475}, {-4.836890997791754, 3.659323719628273}}], 
          
          LineBox[{{-4.836890997791754, 
           3.659323719628273}, {-4.836890997791754, 
           3.6904043363697996`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           3.6094556396289197`}, {-4.7904256789098545`, 
           3.6124207638067767`}}], 
          
          LineBox[{{-4.7904256789098545`, 
           3.6124207638067767`}, {-4.7904256789098545`, 
           3.6153771220090465`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.737293643353486, 
           3.509496782868884}, {-4.737293643353486, 3.5210804633917694`}}], 
          
          LineBox[{{-4.737293643353486, 
           3.5210804633917694`}, {-4.737293643353486, 
           3.5325314973296282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.686843305597875, 
           3.4258481110297896`}, {-4.686843305597875, 3.4467576865254266`}}], 
          
          LineBox[{{-4.686843305597875, 
           3.4467576865254266`}, {-4.686843305597875, 
           3.4672389913478554`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.638816810695785, 
           3.371065681503043}, {-4.638816810695785, 3.3807613927041227`}}], 
          
          LineBox[{{-4.638816810695785, 
           3.3807613927041227`}, {-4.638816810695785, 
           3.3903639990845926`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.585618618209504, 
           3.2905975853625584`}, {-4.585618618209504, 3.322836335082933}}], 
          
          LineBox[{{-4.585618618209504, 
           3.322836335082933}, {-4.585618618209504, 
           3.3540681264135257`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.5349866218238715`, 
           3.1740595182628266`}, {-4.5349866218238715`, 
           3.1933069109451204`}}], 
          
          LineBox[{{-4.5349866218238715`, 
           3.1933069109451204`}, {-4.5349866218238715`, 
           3.21219082648062}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.486906098502099, 
           3.1006681109392016`}, {-4.486906098502099, 3.1101706478488556`}}], 
          
          LineBox[{{-4.486906098502099, 
           3.1101706478488556`}, {-4.486906098502099, 
           3.1195837358753535`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.434587362995433, 
           2.9943503115991286`}, {-4.434587362995433, 3.0127524214796875`}}], 
          
          LineBox[{{-4.434587362995433, 
           3.0127524214796875`}, {-4.434587362995433, 
           3.0308220037084324`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.384870809286841, 
           2.8892101062464226`}, {-4.384870809286841, 2.908272592015705}}], 
          
          LineBox[{{-4.384870809286841, 
           2.908272592015705}, {-4.384870809286841, 
           2.9269784863445905`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.331793922235689, 
           2.82955410769011}, {-4.331793922235689, 2.840738477827915}}], 
          
          LineBox[{{-4.331793922235689, 
           2.840738477827915}, {-4.331793922235689, 2.85179914014907}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.281298916050743, 
           2.7737741315267304`}, {-4.281298916050743, 2.7895360861172565`}}], 
          
          LineBox[{{-4.281298916050743, 
           2.7895360861172565`}, {-4.281298916050743, 
           2.805053451710781}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.233317532819553, 
           2.6862718073430707`}, {-4.233317532819553, 2.6955618397527084`}}], 
          
          LineBox[{{-4.233317532819553, 
           2.6955618397527084`}, {-4.233317532819553, 
           2.7047663612499853`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.182528650278334, 
           2.5730572693880474`}, {-4.182528650278334, 2.591659981908015}}], 
          
          LineBox[{{-4.182528650278334, 
           2.591659981908015}, {-4.182528650278334, 
           2.6099229441724634`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.134195560414886, 
           2.503344055844009}, {-4.134195560414886, 2.512183456640269}}], 
          
          LineBox[{{-4.134195560414886, 
           2.512183456640269}, {-4.134195560414886, 
           2.5209454065496417`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.083632876366685, 
           2.385729772586166}, {-4.083632876366685, 2.4037073189675944`}}], 
          
          LineBox[{{-4.083632876366685, 
           2.4037073189675944`}, {-4.083632876366685, 
           2.4213673725174454`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.031202073622229, 
           2.3122252340691336`}, {-4.031202073622229, 2.32904300774497}}], 
          
          LineBox[{{-4.031202073622229, 
           2.32904300774497}, {-4.031202073622229, 2.345582615591575}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9813843596872887`, 
           2.2130810067080646`}, {-3.9813843596872887`, 
           2.2297769278709616`}}], 
          
          LineBox[{{-3.9813843596872887`, 
           2.2297769278709616`}, {-3.9813843596872887`, 
           2.2461986667123717`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9339315540729225`, 
           2.096287041882176}, {-3.9339315540729225`, 2.1168429550305077`}}], 
          
          LineBox[{{-3.9339315540729225`, 
           2.1168429550305077`}, {-3.9339315540729225`, 
           2.136984819477058}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8849743942398893`, 
           2.0065855120328795`}, {-3.8849743942398893`, 
           2.0303445767808586`}}], 
          
          LineBox[{{-3.8849743942398893`, 
           2.0303445767808586`}, {-3.8849743942398893`, 
           2.053552224194723}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8347700755229908`, 
           1.8999354818632646`}, {-3.8347700755229908`, 
           1.9126866429199154`}}], 
          
          LineBox[{{-3.8347700755229908`, 
           1.9126866429199154`}, {-3.8347700755229908`, 
           1.9252772568822294`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7836656131917032`, 
           1.8157604884885807`}, {-3.7836656131917032`, 1.824303574045115}}], 
          LineBox[{{-3.7836656131917032`, 
           1.824303574045115}, {-3.7836656131917032`, 
           1.8327742930877375`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7318587542877983`, 
           1.6697294320676583`}, {-3.7318587542877983`, 
           1.6847008998644861`}}], 
          
          LineBox[{{-3.7318587542877983`, 
           1.6847008998644861`}, {-3.7318587542877983`, 
           1.69945152508665}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.6826046446528315`, 
           1.578304300033921}, {-3.6826046446528315`, 1.589389933449115}}], 
          
          LineBox[{{-3.6826046446528315`, 
           1.589389933449115}, {-3.6826046446528315`, 
           1.6003540217693781`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.6328247148137414`, 
           1.4843103440623633`}, {-3.6328247148137414`, 
           1.4989668738068938`}}], 
          
          LineBox[{{-3.6328247148137414`, 
           1.4989668738068938`}, {-3.6328247148137414`, 
           1.5134116889534246`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.582661256928897, 
           1.3892921400472547`}, {-3.582661256928897, 1.4069140330939243`}}], 
          
          LineBox[{{-3.582661256928897, 
           1.4069140330939243`}, {-3.582661256928897, 
           1.4242307647868122`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.5323280693679435`, 
           1.3027262451117732`}, {-3.5323280693679435`, 
           1.3145485820331833`}}], 
          
          LineBox[{{-3.5323280693679435`, 
           1.3145485820331833`}, {-3.5323280693679435`, 
           1.3262327828062925`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4819260190211643`, 
           1.1819078698095495`}, {-3.4819260190211643`, 
           1.1948649466059276`}}], 
          
          LineBox[{{-3.4819260190211643`, 
           1.1948649466059276`}, {-3.4819260190211643`, 
           1.2076562827879547`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4339433400456847`, 
           1.0858537560981827`}, {-3.4339433400456847`, 
           1.1001911092771612`}}], 
          
          LineBox[{{-3.4339433400456847`, 
           1.1001911092771612`}, {-3.4339433400456847`, 
           1.1143258049103548`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.383729549397733, 
           0.9687210164211676}, {-3.383729549397733, 0.979421693725143}}], 
          
          LineBox[{{-3.383729549397733, 
           0.979421693725143}, {-3.383729549397733, 0.9900090777792647}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3337423956288244`, 
           0.8688347668651045}, {-3.3337423956288244`, 0.8813420085421828}}], 
          
          LineBox[{{-3.3337423956288244`, 
           0.8813420085421828}, {-3.3337423956288244`, 
           0.8936947495133952}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.284167120918414, 
           0.750559753006227}, {-3.284167120918414, 0.7602039686897286}}], 
          
          LineBox[{{-3.284167120918414, 
           0.7602039686897286}, {-3.284167120918414, 
           0.7697560612253737}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.233062016517094, 
           0.6592713670216815}, {-3.233062016517094, 0.6745193274296407}}], 
          
          LineBox[{{-3.233062016517094, 
           0.6745193274296407}, {-3.233062016517094, 
           0.6895382751470022}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.1826340373457827`, 
           0.569049945135606}, {-3.1826340373457827`, 0.5792718394544509}}], 
          
          LineBox[{{-3.1826340373457827`, 
           0.5792718394544509}, {-3.1826340373457827`, 
           0.5893903030166132}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.1328778939592064`, 
           0.45685397405039124`}, {-3.1328778939592064`, 
           0.4678900868910863}}], 
          
          LineBox[{{-3.1328778939592064`, 
           0.4678900868910863}, {-3.1328778939592064`, 
           0.478805732228757}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.083842293493626, 
           0.35124400606114775`}, {-3.083842293493626, 0.362738259935936}}], 
          
          LineBox[{{-3.083842293493626, 
           0.362738259935936}, {-3.083842293493626, 0.3741018958725985}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.033953781539961, 
           0.24475518170440339`}, {-3.033953781539961, 0.2525452505306486}}], 
          
          LineBox[{{-3.033953781539961, 
           0.2525452505306486}, {-3.033953781539961, 
           0.26027510297219214`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.9829211452899216`, 
           0.1498808804956121}, {-2.9829211452899216`, 
           0.16446606062018584`}}], 
          
          LineBox[{{-2.9829211452899216`, 
           0.16446606062018584`}, {-2.9829211452899216`, 
           0.17884156772085194`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.935437193039225, 
           0.024666004897671488`}, {-2.935437193039225, 
           0.03892221236156202}}], 
          
          LineBox[{{-2.935437193039225, 
           0.03892221236156202}, {-2.935437193039225, 
           0.05297803377320798}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.734894278728679, -0.4027306892199045}, \
{-2.734894278728679, -0.3500378023925535}}], 
          
          LineBox[{{-2.734894278728679, -0.3500378023925535}, \
{-2.734894278728679, -0.2999830259978416}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.4849223397830356`, -0.9415007193952571}, \
{-2.4849223397830356`, -0.8988836272530292}}], 
          
          LineBox[{{-2.4849223397830356`, -0.8988836272530292}, \
{-2.4849223397830356`, -0.8580087561448758}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.380038563220422, -1.168886431219446}, \
{-2.380038563220422, -1.1302696478938354`}}], 
          
          LineBox[{{-2.380038563220422, -1.1302696478938354`}, \
{-2.380038563220422, -1.0930888395888656`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.2851211182798545`, -1.3843332624579716`}, \
{-2.2851211182798545`, -1.3491796839550345`}}], 
          
          LineBox[{{-2.2851211182798545`, -1.3491796839550345`}, \
{-2.2851211182798545`, -1.3152200276640662`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.226506167649257, -1.513443915577809}, \
{-2.226506167649257, -1.4805355958399486`}}], 
          
          LineBox[{{-2.226506167649257, -1.4805355958399486`}, \
{-2.226506167649257, -1.4486758194187817`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -1.6964808470883848`}, \
{-2.144562997373256, -1.6672175837719347`}}], 
          
          LineBox[{{-2.144562997373256, -1.6672175837719347`}, \
{-2.144562997373256, -1.638786368286216}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -1.8188098081823985`}, \
{-2.0934424039470523`, -1.78787548595345}}], 
          
          LineBox[{{-2.0934424039470523`, -1.78787548595345}, \
{-2.0934424039470523`, -1.757869451853188}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0331259247878006`, -1.9623442356846974`}, \
{-2.0331259247878006`, -1.9310525682429114`}}], 
          
          LineBox[{{-2.0331259247878006`, -1.9310525682429114`}, \
{-2.0331259247878006`, -1.9007104319636563`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.976025406568619, -2.089614251106696}, \
{-1.976025406568619, -2.063593181154233}}], 
          
          LineBox[{{-1.976025406568619, -2.063593181154233}, \
{-1.976025406568619, -2.0382320707227337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.9326653384575119`, -2.1893508765055896`}, \
{-1.9326653384575119`, -2.1645978534069954`}}], 
          
          LineBox[{{-1.9326653384575119`, -2.1645978534069954`}, \
{-1.9326653384575119`, -2.140442771403275}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8810672419769725`, -2.3142044837412943`}, \
{-1.8810672419769725`, -2.2860749961801106`}}], 
          
          LineBox[{{-1.8810672419769725`, -2.2860749961801106`}, \
{-1.8810672419769725`, -2.2587151757090957`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8318406272528898`, -2.426208435569265}, \
{-1.8318406272528898`, -2.403611884800499}}], 
          
          LineBox[{{-1.8318406272528898`, -2.403611884800499}, \
{-1.8318406272528898`, -2.3815146755201932`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.7850708398172375`, -2.5440353718334876`}, \
{-1.7850708398172375`, -2.5184299602608564`}}], 
          
          LineBox[{{-1.7850708398172375`, -2.5184299602608564`}, \
{-1.7850708398172375`, -2.493463850265984}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.7316070609965282`, -2.6728610755007756`}, \
{-1.7316070609965282`, -2.6483954516048827`}}], 
          
          LineBox[{{-1.7316070609965282`, -2.6483954516048827`}, \
{-1.7316070609965282`, -2.624514127647388}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.680857774871063, -2.7951027012073832`}, \
{-1.680857774871063, -2.772101404678041}}], 
          
          LineBox[{{-1.680857774871063, -2.772101404678041}, \
{-1.680857774871063, -2.749617294131161}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.632560487956873, -2.9125422624052786`}, \
{-1.632560487956873, -2.8902333419217077`}}], 
          
          LineBox[{{-1.632560487956873, -2.8902333419217077`}, \
{-1.632560487956873, -2.868411268098209}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5864890309770467`, -3.0315029104150426`}, \
{-1.5864890309770467`, -3.0087952313045534`}}], 
          
          LineBox[{{-1.5864890309770467`, -3.0087952313045534`}, \
{-1.5864890309770467`, -2.9865917626203404`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5353513680587525`, -3.1570922475325345`}, \
{-1.5353513680587525`, -3.134386745733925}}], 
          
          LineBox[{{-1.5353513680587525`, -3.134386745733925}, \
{-1.5353513680587525`, -3.1121853587437736`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4798745637368198`, -3.2985070757929527`}, \
{-1.4798745637368198`, -3.2766200353267574`}}], 
          
          LineBox[{{-1.4798745637368198`, -3.2766200353267574`}, \
{-1.4798745637368198`, -3.2552017950652057`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4336874114561198`, -3.4162841265054915`}, \
{-1.4336874114561198`, -3.3963213469751037`}}], 
          
          LineBox[{{-1.4336874114561198`, -3.3963213469751037`}, \
{-1.4336874114561198`, -3.37674929276931}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.3835443794448625`, -3.547640932874873}, \
{-1.3835443794448625`, -3.5247391017646366`}}], 
          
          LineBox[{{-1.3835443794448625`, -3.5247391017646366`}, \
{-1.3835443794448625`, -3.5023500430065866`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.329822772449285, -3.687430836430992}, \
{-1.329822772449285, -3.6679127403357334`}}], 
          
          LineBox[{{-1.329822772449285, -3.6679127403357334`}, \
{-1.329822772449285, -3.648768318540228}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2844243515113174`, -3.8105066020329232`}, \
{-1.2844243515113174`, -3.7907934814181834`}}], 
          
          LineBox[{{-1.2844243515113174`, -3.7907934814181834`}, \
{-1.2844243515113174`, -3.771461467233683}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2357418538566787`, -3.9393223994725814`}, \
{-1.2357418538566787`, -3.9187872788897584`}}], 
          
          LineBox[{{-1.2357418538566787`, -3.9187872788897584`}, \
{-1.2357418538566787`, -3.8986653781925473`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1842463978924687`, -4.079081385213644}, \
{-1.1842463978924687`, -4.058115283303484}}], 
          
          LineBox[{{-1.1842463978924687`, -4.058115283303484}, \
{-1.1842463978924687`, -4.037579746988491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1352739017580313`, -4.209109352236573}, \
{-1.1352739017580313`, -4.191226542932226}}], 
          
          LineBox[{{-1.1352739017580313`, -4.191226542932226}, \
{-1.1352739017580313`, -4.173657918219016}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0840754969609638`, -4.352701378355831}, \
{-1.0840754969609638`, -4.333498579565102}}], 
          
          LineBox[{{-1.0840754969609638`, -4.333498579565102}, \
{-1.0840754969609638`, -4.314657591387746}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0310183660733363`, -4.500803358285759}, \
{-1.0310183660733363`, -4.48247904250758}}], 
          
          LineBox[{{-1.0310183660733363`, -4.48247904250758}, \
{-1.0310183660733363`, -4.464484473946707}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9806356434778151, -4.642961383252678}, \
{-0.9806356434778151, -4.625173953253483}}], 
          
          LineBox[{{-0.9806356434778151, -4.625173953253483}, \
{-0.9806356434778151, -4.607697394375036}}]}}}}}, {{{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.01]], 
        PointBox[CompressedData["
1:eJwVxXk81HkfAPDBDHMZc2MSK+vY0pZssrvy+/YybAq56WBpW+JxrCM3KVkJ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         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{Small, Small}]], 
        PointBox[CompressedData["
1:eJwV0H8803kcwPGZbWY2+31FxLpIi+sHKdf0/cgoV4oyuoooComKSl2UCl2J
uEoq63ElkawkP0r6vBP9EqFSKE1GosKGiei6P16P5/8v0YaIlUFkEom09mf/
G9EtXhXVK4RGurVTWosQbVtPLVKWCmGQSJgqUQjRLkH0mTXxQghM3yS7JBOi
4rRdSN9LCK5pAbGaaUL0Zu25aAcLIYy7jDZYtQkQJL82rPskgBPutiXUcgHq
/ofByy0QQPAx3yqfJAHy3TU/b+s+AbztFKumOglQ1SzpxxduAjAvqdOVdfFR
85crnueNBEBO7xZuSOUjabiHNqWHD5LTVUtZi/jIIpFW9/YWH0Sn43oSNDxU
W93WWnGAD+bdIt1rmTw0aH6s0WcFHy6lSz6eseShjqtCZe8vfIgS+i1rVHJR
WaFMtLeNBye7RdPM93BR3lypIk/Bg+lGARus9LgonuXpKo3lAXv7ETvRAw6K
dDq0munBgyRj7fMVURzUGcP2uWnCg8HID9/8OBzUx6e0fVVxQSK2nhKxmo30
mg+PMW9wYYq5zYztxYZozdO9lpUxXAgTL1MO97DQARs1v9GdC67tVak5DixU
gKjRh4y5oPgR9XLiNia6IZkpc1dxoOjObTLzmQH6LJFL629wwLEr+E+bEQZS
myUFPtvPgRyFfbKHKQOhQ6N7YpdxIMKHFD4i00c5D+WeqZM4UN1Rr2DF01G0
3PhkXj0bSspbpod16iHn+94GvcFsiPA0a6YP0JB/1kKfLVQ21Aaqr8e40JDf
EW9v2QVDWLL6rofRFiqa7WviFjDPEBinS1s4MgoSzQ8KGaphAS9+6WEUpYuW
x3ZMKwphwW1VpCgmk4wEJvcs11BYMBDCqDEt0EG1JoXtM+VMGK947ZU5RweV
zd7df3keE7YlpjusdiKhpRmJK/vrDCBT/MrdoXScKFwIxSGhBmAZ8FLcYjhG
9LpWps6hGMAm6zDSlY2jhLX/xZgUOQM63runXPr3G2EY/31C/FwGmF3YlzAP
DRPMh9GbrtXow63Tjl0Wc4cIPVPf2a9D9WHB5riM/IIBovaT3YqjVH1g3X64
1VusITxD121aIKfDNQX5jevGfiLPY7i+eD4d/Iv37kiJ7yVycxMuxtXrAWmy
Z2bskx5ieDr6tX+nHuDmFLZa3kVYZCT4uXygwQvBqYnQoCKyhmebSnbToG78
MZcsbSNk+2bxDnNpsNDfT20W20Ls17sYfv4GFRyyA5SqLy+JAH/7KqEXFeJa
14WkTKwhZn55MjVllALvZ3Sc4imBsE7/I7MwmwKTvgsPPtZkEduHM0wZv1Gg
lur4wllSgjtrmxZsKNOFXHH83rL0auzC6zuavkMXlgzRlqqaGrCJzsEcT4Yu
GLVHh3QbNePqDOmzlGwyuPT0nz9brsRpboUnvywmw5zp8oZZAhW+Jbbd/eG5
Dli7aE0ere/COcb83Bg/HVj2Kuht+1+f8b2baSFMDQny29Psw3/vwxZxISVD
SSTo8xNPnmGpxssD5Y53ZpDAJVTS2qrW4E8RgvpnmT9w1vKi3qHrg7jybFjM
nM/j2NFox6DdKi0ObH831DRxHC9Qinul3t9wTCjdIdxqDAsDgrIMroziPu93
25mh33HpIsUWWsIY9jKgn8u9NYovi4odRtx+4DcPpWbVqhFcYHex6lE+CZTO
dKydPIKfv6p0dMrVgfOFlKJO52+4+/t+K4+nZOgJRq+jIoexrWXpYuLdzy+f
vDUn8rV4wjkdPuMjBWzdIp2WNA7hnKsVi8R0GrSShQWgP4Szr2/2umOqB11e
KxcOuA5i1UHu/GQbOhz/6jw5cdcATvKsL49apQ/tJ/N5f5/V4M4fkuQnxxmw
W1GlrHiixiMbtWNv7hpA/4PMSlNdNbbaqHStaWJCndZd4WPbjw/blvM0bEPI
Pl5j4bG1DxsG372TKGHD/Z1BaBbqxQdbzbRX7TnwHzSSvqU=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{0, Small}]], 
        PointBox[CompressedData["
1:eJwVxXk4lHkcAPAxM5gx5jKE5FhHuUohRLxvrh5X7msJtVqFKFt45IqyGCEl
V7ZaJcSmkK71+xZqMdmOZ0KWRWXdx5hxpWl3//g8n+8Ox3odIRIIBK///H+X
we6AUD95aAkve8vfw8I/zN72vKosDzuU+Ut5p5m4fYzHSsE0B7oHhxXiFZg4
k5jMSEMcKOF26P/0gIF7PLwmKcPlQGFNHCdgiY6H+GwTrgVwIMmmLtPFkY6n
BfwQeESPAwrZaYN7x2VxkUTf5q8COdj3ZtzK0EAW/5uzMeCN5EBpovqeqIiG
G7kkinXy5WBeQL3Bo9HwwQumR+v95WCX5jFzg2IZvEc9LvudlhyIeOGpn7hU
PEpXJ7NEwIZT07StN0YpuHC/dSL5dzY8LaMuqm6m4B1OvCKVXDaoJTdHadtL
40YM065n3mwY5/gp8R9J4e7fN72V1WBDpMJtl1UPKTzG8HL31BwLRHWvH2UU
SuJbVUO6Jx6z4JXhecuHT8i4H6GyIDKHBf2XhquWlMi4Yrz3YJUvC3TXNP7p
tiThp5RbY5fUWTA0P+k6eoOIH3ej00YGmKBbbepU/F4Cbyl0UbmXyASSWBjk
Mk/AbeKzTx2XZ8IKZ5urjg0BfxexMFfRwIDr4dvdD5aLsc92qkkCewY0i18u
Buz8irXVmLf3f6CDYtD+uWzhOsal/xy9dpoOvE15Wtoxa9j0q5MRUiw6nKtw
bez4soKZY8oHnGtlYQVJOT/MWMbeRUta7LaVBWIoXSmcIsK4rn7SGx9ocEfA
a9ZXW8LOnN3h1JpIg70aKuJD5YtYVJgTb4RNg+SgRb1o/3nsrqq85tk7MvBA
MLFNaDKD/cj1P7bmIAOm62sOJd4T2FOa/y/uQ1QwupiUX1v8GZtyzuNT4qmQ
H9WmdCRnDHPwkXbSZFGBn+BjN7k4hJlUame03KHA8P3B7M3mfZilZ2RBjgMF
HDMFF5r0XmNhOTPPJYekgWPKd99D78T0s56mvjgjDc8qgh9fna3CdMqyQhzG
pKAmoao/ubgZ3Vzdpbo3QQroMavqKQV/oKl9x3DWqCS4LR4VkiPeo0NhZp0K
PpKQ0isg7CSNIKPZLu2CL2SITr0oHJT9iAxLnCubqslgbCvwNqSNoy121TkW
vmS4pZESsqNtAvm1NS2rjZIgr7Ot9Hb7DHKQW8gtiSNBZdzEXwccF9AWiYwa
TxkSTPf7Xi9WEKCeMnteQTURPCIEL15OL6Eip6bLs/uJEGjVGGt9RYSa9U0S
xv6UgHrtHkXHxhV0spz/hJUkAbZ95wkVZmso9ATzFktXAkqHAgNm6tcRUVn3
SQgiwPM+f2+tig2kNxGc1WdHgGvBrWEln8VoMlb+Da/yG3oe56xtnUGAjvLo
FOMZMWr8NtWg5CkB4R+HlgeUxIgeJtU46kSE3EIlNQv3r+ijyGC41JIEz+ZG
TlQXbCDF++EVbTpk8KFRKmqbvyBVnWDhpJEk9L+wV+/5tI4y3bzS7bZLwYgd
Ba2oraOT47k1xurSkKCT6GV7eA01ZixbkeQoYDJeXsorXEVR3LtBezhUUJ70
WypsWEHXDGsLz5nJAL6PYXZ4YRl1taKsOgMaqCSHx3zTXEaVipTIOmNZmPDx
shE6itDqlYxfx/zpkMhPzSNcECJGdXg215sBFr1UvKxzCf2WtkmnIZAJvbX8
wHqBALW03SzKsGKB/0D6iry+AOUrsD69bmcBMelgXmjAIjqx/qY63ZcN8+3W
qvS0BWTnFrfBmGPDrTmcEHJoHl3S6i3bni4H/wJTLoGd
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -5.55069839199171}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-5.55069839199171, 
      6.956670316206544}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C14\"", "\"C15\"", "\"C16\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9},
 CellLabel->
  "Out[593]=",ExpressionUUID->"6bbc0431-54ea-4bbe-8390-2c64add739b1"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\DataMergedBinnedC14-16.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.9059261161819143`*^9},
 CellLabel->
  "Out[594]=",ExpressionUUID->"b903504c-0c44-4600-8344-0c8d0ff13251"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.962020517152551, -1.7975229365155172`}, \
{-4.962020517152551, -1.4904522790582342`}}], 
          
          LineBox[{{-4.962020517152551, -1.4904522790582342`}, \
{-4.962020517152551, -1.1833816216009512`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.812318020609066, -1.7499804854261338`}, \
{-4.812318020609066, -1.484844590276649}}], 
          
          LineBox[{{-4.812318020609066, -1.484844590276649}, \
{-4.812318020609066, -1.219708695127164}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.662288009830052, -1.731832308155819}, \
{-4.662288009830052, -1.484844094732198}}], 
          
          LineBox[{{-4.662288009830052, -1.484844094732198}, \
{-4.662288009830052, -1.237855881308577}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.510921616983912, -2.1820005297355953`}, \
{-4.510921616983912, -1.9277101971080235`}}], 
          
          LineBox[{{-4.510921616983912, -1.9277101971080235`}, \
{-4.510921616983912, -1.6734198644804519`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.358825697731176, -1.7496301838784403`}, \
{-4.358825697731176, -1.5407870885745718`}}], 
          
          LineBox[{{-4.358825697731176, -1.5407870885745718`}, \
{-4.358825697731176, -1.3319439932707033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.206267641506683, -2.0186112646490657`}, \
{-4.206267641506683, -1.8301249552977674`}}], 
          
          LineBox[{{-4.206267641506683, -1.8301249552977674`}, \
{-4.206267641506683, -1.6416386459464691`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.056255653469975, -2.045423498599775}, \
{-4.056255653469975, -1.8298421264932705`}}], 
          
          LineBox[{{-4.056255653469975, -1.8298421264932705`}, \
{-4.056255653469975, -1.6142607543867664`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.9071666992729934`, -2.2539753896725387`}, \
{-3.9071666992729934`, -2.048083845765819}}], 
          
          LineBox[{{-3.9071666992729934`, -2.048083845765819}, \
{-3.9071666992729934`, -1.8421923018590989`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7563029605395606`, -2.356016322351946}, \
{-3.7563029605395606`, -2.1793864693343323`}}], 
          
          LineBox[{{-3.7563029605395606`, -2.1793864693343323`}, \
{-3.7563029605395606`, -2.0027566163167188`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6055069407082008`, -2.0712591417540867`}, \
{-3.6055069407082008`, -1.9041921854873916`}}], 
          
          LineBox[{{-3.6055069407082008`, -1.9041921854873916`}, \
{-3.6055069407082008`, -1.7371252292206965`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4564260807134493`, -2.3154337014558}, \
{-3.4564260807134493`, -2.1486849495091764`}}], 
          
          LineBox[{{-3.4564260807134493`, -2.1486849495091764`}, \
{-3.4564260807134493`, -1.9819361975625527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3071524238710044`, -2.236134018237064}, \
{-3.3071524238710044`, -2.0916457307990073`}}], 
          
          LineBox[{{-3.3071524238710044`, -2.0916457307990073`}, \
{-3.3071524238710044`, -1.9471574433609504`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.156690529396256, -2.207572101104361}, \
{-3.156690529396256, -2.0758943792454656`}}], 
          
          LineBox[{{-3.156690529396256, -2.0758943792454656`}, \
{-3.156690529396256, -1.9442166573865698`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.0195378319942416`, -2.242122341649085}, \
{-3.0195378319942416`, -2.0720360768688115`}}], 
          
          LineBox[{{-3.0195378319942416`, -2.0720360768688115`}, \
{-3.0195378319942416`, -1.9019498120885379`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8585261080745212`, -2.317698131453854}, \
{-2.8585261080745212`, -2.0032105152590582`}}], 
          
          LineBox[{{-2.8585261080745212`, -2.0032105152590582`}, \
{-2.8585261080745212`, -1.6887228990642622`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.691382454472379, -2.78784802624227}, \
{-2.691382454472379, -2.1892779813885275`}}], 
          
          LineBox[{{-2.691382454472379, -2.1892779813885275`}, \
{-2.691382454472379, -1.5907079365347847`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5545155316419494`, -2.7417402803813147`}, \
{-2.5545155316419494`, -2.1924652191783975`}}], 
          
          LineBox[{{-2.5545155316419494`, -2.1924652191783975`}, \
{-2.5545155316419494`, -1.6431901579754804`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.408966023604327, -2.7235790038725742`}, \
{-2.408966023604327, -2.242770317295063}}], 
          
          LineBox[{{-2.408966023604327, -2.242770317295063}, \
{-2.408966023604327, -1.7619616307175516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.2588388882868426`, -2.729795390355834}, \
{-2.2588388882868426`, -2.268822869979683}}], 
          
          LineBox[{{-2.2588388882868426`, -2.268822869979683}, \
{-2.2588388882868426`, -1.807850349603532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1096964413451786`, -2.7535327288177047`}, \
{-2.1096964413451786`, -2.3379921382936306`}}], 
          
          LineBox[{{-2.1096964413451786`, -2.3379921382936306`}, \
{-2.1096964413451786`, -1.9224515477695563`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9578947894818906`, -2.7345648695754594`}, \
{-1.9578947894818906`, -2.3436357189221946`}}], 
          
          LineBox[{{-1.9578947894818906`, -2.3436357189221946`}, \
{-1.9578947894818906`, -1.9527065682689297`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8071283500440232`, -2.7889862251377617`}, \
{-1.8071283500440232`, -2.4214478851744476`}}], 
          
          LineBox[{{-1.8071283500440232`, -2.4214478851744476`}, \
{-1.8071283500440232`, -2.0539095452111336`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.65618364739931, -2.81505323267394}, \
{-1.65618364739931, -2.4706079244040438`}}], 
          
          LineBox[{{-1.65618364739931, -2.4706079244040438`}, \
{-1.65618364739931, -2.1261626161341476`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5040228008910033`, -2.875105173039695}, \
{-1.5040228008910033`, -2.5481456990090083`}}], 
          
          LineBox[{{-1.5040228008910033`, -2.5481456990090083`}, \
{-1.5040228008910033`, -2.2211862249783216`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3539296288670801`, -2.956534168031409}, \
{-1.3539296288670801`, -2.6412677590483873`}}], 
          
          LineBox[{{-1.3539296288670801`, -2.6412677590483873`}, \
{-1.3539296288670801`, -2.326001350065366}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2055237319284868`, -3.0030836819866935`}, \
{-1.2055237319284868`, -2.702590293800939}}], 
          
          LineBox[{{-1.2055237319284868`, -2.702590293800939}, \
{-1.2055237319284868`, -2.4020969056151844`}}]}}}}, {{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.6554248936175195`, -0.7441437755638183}, 
             
             Offset[{3, 
              0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -0.7441437755638183}, 
             
             Offset[{-3, 
              0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
             
             Offset[{3, 
              0}, {-5.6554248936175195`, -1.3754752798292404`}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
             
             Offset[{-3, 
              0}, {-5.6554248936175195`, -1.3754752798292404`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.505650557368423, -0.9924807745504116}, 
             
             Offset[{3, 
              0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -0.9924807745504116}, 
             
             Offset[{-3, 
              0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
             
             Offset[{3, 
              0}, {-5.505650557368423, -1.6058265850271665`}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
             
             Offset[{-3, 
              0}, {-5.505650557368423, -1.6058265850271665`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -1.2311119743742258`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.2311119743742258`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.8664192256781258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.8664192256781258`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -1.3283040995583626`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.3283040995583626`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.9160413309640592`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.9160413309640592`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.3482851486157643`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.3482851486157643`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.9443899812655037`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.9443899812655037`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.4799067173910923`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -1.4799067173910923`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -2.054729383000484}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.054729383000484}]}, \
{{-4.894444132978499, -2.054729383000484}, 
             Offset[{-3, 0}, {-4.894444132978499, -2.054729383000484}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.5143222181665987`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -1.5143222181665987`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.0436838539320887`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.0436838539320887`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.6486237451356507`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -1.6486237451356507`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -2.155055401276338}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.155055401276338}]}, \
{{-4.596628633102665, -2.155055401276338}, 
             Offset[{-3, 0}, {-4.596628633102665, -2.155055401276338}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.6732512712660113`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -1.6732512712660113`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -2.141283295074858}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.141283295074858}]}, \
{{-4.447741719114617, -2.141283295074858}, 
             Offset[{-3, 0}, {-4.447741719114617, -2.141283295074858}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.7382252968026495`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -1.7382252968026495`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.1741403061228324`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -2.1741403061228324`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.787097564122895}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -1.787097564122895}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.2157632698654677`}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -2.2157632698654677`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.7792387109438086`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -1.7792387109438086`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -2.180179830632701}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.180179830632701}]}, \
{{-4.001278268975371, -2.180179830632701}, 
             Offset[{-3, 0}, {-4.001278268975371, -2.180179830632701}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -1.9867056555976979`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -1.9867056555976979`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.3621772224343935`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.3621772224343935`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.8553845713050103`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -1.8553845713050103`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.21519821644171}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.21519821644171}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.9583043981530677`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -1.9583043981530677`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.2882721832855677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -2.2882721832855677`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -1.9620324663184738`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -1.9620324663184738`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.2596424372692936`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.2596424372692936`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -1.9788487659440033`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -1.9788487659440033`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.262247354252459}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.262247354252459}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -2.056739465127449}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.056739465127449}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.325682989323952}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.325682989323952}]}, \
{{-3.099363949694378, -2.325682989323952}, 
             Offset[{-3, 0}, {-3.099363949694378, -2.325682989323952}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.8949748050646635`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -1.8949748050646635`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.3447234080641337`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.3447234080641337`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.8217119751233666`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -1.8217119751233666`}, 
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.4254477492472883`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.4254477492472883`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.7157691886697428`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -1.7157691886697428`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.8413253632452493`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.8413253632452493`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.766680406620364}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -1.766680406620364}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.8224766777422747`}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.8224766777422747`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.8863950639650633`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -1.8863950639650633`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.8819377562355633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.8819377562355633`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.973647393257782}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -1.973647393257782}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.8970664017320726`}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.8970664017320726`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -2.059884528392571}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.059884528392571}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.968529373545217}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.968529373545217}]}, \
{{-2.048114358050804, -2.968529373545217}, 
             Offset[{-3, 0}, {-2.048114358050804, -2.968529373545217}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.15047020595956}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -2.15047020595956}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -3.0022765477363382`}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -3.0022765477363382`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.2949883042796384`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -2.2949883042796384`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -3.094837271329944}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -3.094837271329944}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.43415544885491}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.43415544885491}]}, \
{{-1.6053998639759, -2.43415544885491}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.43415544885491}]}, \
{{-1.6053998639759, -3.1963113633507874`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -3.1963113633507874`}]}, \
{{-1.6053998639759, -3.1963113633507874`}, 
             Offset[{-3, 0}, {-1.6053998639759, -3.1963113633507874`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.579906696996963}, 
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -2.579906696996963}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.319806547313522}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.319806547313522}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.726672657218819}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -2.726672657218819}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.4374715265753477`}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.4374715265753477`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.8829266852659527`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -2.8829266852659527`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.575354502019425}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.575354502019425}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0007923805337786`, -3.02191162543404}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.02191162543404}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.6838381654034302`}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.6838381654034302`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-0.8504177096512346, -3.090902133771868}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.090902133771868}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.7163191294527014`}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.7163191294527014`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -0.9105090255547197}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -0.9105090255547197}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.3931597078962221`}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.3931597078962221`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -0.8265043801949042}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -0.8265043801949042}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.3134154073527315`}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.3134154073527315`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.4020134632993138`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.4020134632993138`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.9504581230708071`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.9504581230708071`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.461587386422944}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -1.461587386422944}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.0135895487593514`}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -2.0135895487593514`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.546177059472098}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -1.546177059472098}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.1041540613861183`}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.1041540613861183`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.5140790079547868`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -1.5140790079547868`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.0307430586360637`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -2.0307430586360637`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.5280315718290023`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -1.5280315718290023`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.0169830121124313`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -2.0169830121124313`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.6366480014197775`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -1.6366480014197775`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.0626503772314857`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -2.0626503772314857`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.8285018616140096`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -1.8285018616140096`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -2.236616860168895}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.236616860168895}]}, \
{{-4.149632905511913, -2.236616860168895}, 
             Offset[{-3, 0}, {-4.149632905511913, -2.236616860168895}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.7138844242888587`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -1.7138844242888587`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -2.126596922805546}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.126596922805546}]}, \
{{-4.001278268975371, -2.126596922805546}, 
             Offset[{-3, 0}, {-4.001278268975371, -2.126596922805546}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -2.0007759127121916`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.0007759127121916`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.405553425795285}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.405553425795285}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.9519006521545337`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -1.9519006521545337`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.3164167395806587`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.3164167395806587`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.891434700925044}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -1.891434700925044}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -2.203216947445259}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.203216947445259}]}, \
{{-3.550260154845919, -2.203216947445259}, 
             Offset[{-3, 0}, {-3.550260154845919, -2.203216947445259}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -1.9293147966750681`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -1.9293147966750681`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.2307861716923925`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.2307861716923925`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -1.973600937585895}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -1.973600937585895}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.2478328027805525`}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.2478328027805525`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -1.9655919070640282`}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -1.9655919070640282`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.2353296307097104`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.2353296307097104`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.9524435509859663`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -1.9524435509859663`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.3858567159594695`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.3858567159594695`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.7218101210108534`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -1.7218101210108534`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.306313665840845}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.306313665840845}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.6604988791243374`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -1.6604988791243374`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.7518917128356595`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.7518917128356595`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.7152118735552495`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -1.7152118735552495`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.7366945816937207`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.7366945816937207`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.811891979369042}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -1.811891979369042}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.772455987224709}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.772455987224709}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.8874413836542725`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -1.8874413836542725`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.7715253067085035`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.7715253067085035`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -1.95131004021657}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -1.95131004021657}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.8147049786780887`}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.8147049786780887`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.0300571436918498`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.0300571436918498`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.832278194104769}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.832278194104769}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.1381798618867163`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.1381798618867163`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.8846177931737373`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.8846177931737373`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.2610876160901254`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.2610876160901254`}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.9663156495983545`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
             Offset[{-3, 0}, {-1.6053998639759, -2.9663156495983545`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.356976803291588}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -2.356976803291588}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.0377885868632313`}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.0377885868632313`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.4961874623395137`}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -2.4961874623395137`}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.144948413067255}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.144948413067255}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.6035100679430707`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -2.6035100679430707`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.234763455290838}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.234763455290838}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.962020517152551, -1.1833816216009512`}, 
             
             Offset[{3, 
              0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.1833816216009512`}, 
             
             Offset[{-3, 
              0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
             
             Offset[{3, 
              0}, {-4.962020517152551, -1.7975229365155172`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
             
             Offset[{-3, 
              0}, {-4.962020517152551, -1.7975229365155172`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.812318020609066, -1.219708695127164}, 
             
             Offset[{3, 
              0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.219708695127164}, 
             
             Offset[{-3, 
              0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
             
             Offset[{3, 
              0}, {-4.812318020609066, -1.7499804854261338`}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
             
             Offset[{-3, 
              0}, {-4.812318020609066, -1.7499804854261338`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.662288009830052, -1.237855881308577}, 
             
             Offset[{3, 
              0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.237855881308577}, 
             
             Offset[{-3, 
              0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.731832308155819}, 
             
             Offset[{3, 
              0}, {-4.662288009830052, -1.731832308155819}]}, \
{{-4.662288009830052, -1.731832308155819}, 
             Offset[{-3, 0}, {-4.662288009830052, -1.731832308155819}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.510921616983912, -1.6734198644804519`}, 
             
             Offset[{3, 
              0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -1.6734198644804519`}, 
             
             Offset[{-3, 
              0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
             
             Offset[{3, 
              0}, {-4.510921616983912, -2.1820005297355953`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
             
             Offset[{-3, 
              0}, {-4.510921616983912, -2.1820005297355953`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.358825697731176, -1.3319439932707033`}, 
             
             Offset[{3, 
              0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.3319439932707033`}, 
             
             Offset[{-3, 
              0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
             
             Offset[{3, 
              0}, {-4.358825697731176, -1.7496301838784403`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
             
             Offset[{-3, 
              0}, {-4.358825697731176, -1.7496301838784403`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.206267641506683, -1.6416386459464691`}, 
             
             Offset[{3, 
              0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -1.6416386459464691`}, 
             
             Offset[{-3, 
              0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
             
             Offset[{3, 
              0}, {-4.206267641506683, -2.0186112646490657`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
             
             Offset[{-3, 
              0}, {-4.206267641506683, -2.0186112646490657`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.056255653469975, -1.6142607543867664`}, 
             Offset[{3, 
              0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -1.6142607543867664`}, 
             
             Offset[{-3, 
              0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -2.045423498599775}, 
             
             Offset[{3, 
              0}, {-4.056255653469975, -2.045423498599775}]}, \
{{-4.056255653469975, -2.045423498599775}, 
             Offset[{-3, 0}, {-4.056255653469975, -2.045423498599775}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.9071666992729934`, -1.8421923018590989`}, 
             
             Offset[{3, 
              0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -1.8421923018590989`}, 
             
             Offset[{-3, 
              0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
             
             Offset[{3, 
              0}, {-3.9071666992729934`, -2.2539753896725387`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
             
             Offset[{-3, 
              0}, {-3.9071666992729934`, -2.2539753896725387`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.7563029605395606`, -2.0027566163167188`}, 
             
             Offset[{3, 
              0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.0027566163167188`}, 
             
             Offset[{-3, 
              0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
             
             Offset[{3, 
              0}, {-3.7563029605395606`, -2.356016322351946}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
             
             Offset[{-3, 
              0}, {-3.7563029605395606`, -2.356016322351946}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6055069407082008`, -1.7371252292206965`}, 
             
             Offset[{3, 
              0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -1.7371252292206965`}, 
             
             Offset[{-3, 
              0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
             
             Offset[{3, 
              0}, {-3.6055069407082008`, -2.0712591417540867`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
             
             Offset[{-3, 
              0}, {-3.6055069407082008`, -2.0712591417540867`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4564260807134493`, -1.9819361975625527`}, 
             
             Offset[{3, 
              0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -1.9819361975625527`}, 
             
             Offset[{-3, 
              0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
             
             Offset[{3, 
              0}, {-3.4564260807134493`, -2.3154337014558}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
             Offset[{-3, 0}, {-3.4564260807134493`, -2.3154337014558}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3071524238710044`, -1.9471574433609504`}, 
             
             Offset[{3, 
              0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -1.9471574433609504`}, 
             
             Offset[{-3, 
              0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
             
             Offset[{3, 
              0}, {-3.3071524238710044`, -2.236134018237064}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
             
             Offset[{-3, 
              0}, {-3.3071524238710044`, -2.236134018237064}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.156690529396256, -1.9442166573865698`}, 
             
             Offset[{3, 
              0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -1.9442166573865698`}, 
             
             Offset[{-3, 
              0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -2.207572101104361}, 
             
             Offset[{3, 
              0}, {-3.156690529396256, -2.207572101104361}]}, \
{{-3.156690529396256, -2.207572101104361}, 
             Offset[{-3, 0}, {-3.156690529396256, -2.207572101104361}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.0195378319942416`, -1.9019498120885379`}, 
             
             Offset[{3, 
              0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -1.9019498120885379`}, 
             
             Offset[{-3, 
              0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
             
             Offset[{3, 
              0}, {-3.0195378319942416`, -2.242122341649085}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
             
             Offset[{-3, 
              0}, {-3.0195378319942416`, -2.242122341649085}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8585261080745212`, -1.6887228990642622`}, 
             
             Offset[{3, 
              0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -1.6887228990642622`}, 
             
             Offset[{-3, 
              0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
             
             Offset[{3, 
              0}, {-2.8585261080745212`, -2.317698131453854}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
             
             Offset[{-3, 
              0}, {-2.8585261080745212`, -2.317698131453854}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.691382454472379, -1.5907079365347847`}, 
             
             Offset[{3, 
              0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -1.5907079365347847`}, 
             
             Offset[{-3, 
              0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -2.78784802624227}, 
             
             Offset[{3, 
              0}, {-2.691382454472379, -2.78784802624227}]}, \
{{-2.691382454472379, -2.78784802624227}, 
             Offset[{-3, 0}, {-2.691382454472379, -2.78784802624227}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5545155316419494`, -1.6431901579754804`}, 
             
             Offset[{3, 
              0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -1.6431901579754804`}, 
             
             Offset[{-3, 
              0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
             
             Offset[{3, 
              0}, {-2.5545155316419494`, -2.7417402803813147`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
             
             Offset[{-3, 
              0}, {-2.5545155316419494`, -2.7417402803813147`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.408966023604327, -1.7619616307175516`}, 
             
             Offset[{3, 
              0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -1.7619616307175516`}, 
             
             Offset[{-3, 
              0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
             
             Offset[{3, 
              0}, {-2.408966023604327, -2.7235790038725742`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
             
             Offset[{-3, 
              0}, {-2.408966023604327, -2.7235790038725742`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.2588388882868426`, -1.807850349603532}, 
             
             Offset[{3, 
              0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -1.807850349603532}, 
             
             Offset[{-3, 
              0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
             
             Offset[{3, 
              0}, {-2.2588388882868426`, -2.729795390355834}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
             
             Offset[{-3, 
              0}, {-2.2588388882868426`, -2.729795390355834}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1096964413451786`, -1.9224515477695563`}, 
             
             Offset[{3, 
              0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -1.9224515477695563`}, 
             
             Offset[{-3, 
              0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
             
             Offset[{3, 
              
              0}, {-2.1096964413451786`, -2.7535327288177047`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
             
             Offset[{-3, 
              0}, {-2.1096964413451786`, -2.7535327288177047`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9578947894818906`, -1.9527065682689297`}, 
             
             Offset[{3, 
              0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -1.9527065682689297`}, 
             
             Offset[{-3, 
              0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
             
             Offset[{3, 
              0}, {-1.9578947894818906`, -2.7345648695754594`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
             
             Offset[{-3, 
              0}, {-1.9578947894818906`, -2.7345648695754594`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8071283500440232`, -2.0539095452111336`}, 
             
             Offset[{3, 
              0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.0539095452111336`}, 
             
             Offset[{-3, 
              0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
             
             Offset[{3, 
              0}, {-1.8071283500440232`, -2.7889862251377617`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
             
             Offset[{-3, 
              0}, {-1.8071283500440232`, -2.7889862251377617`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.65618364739931, -2.1261626161341476`}, 
             
             Offset[{3, 
              0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.1261626161341476`}, 
             
             Offset[{-3, 
              0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.81505323267394}, 
             
             Offset[{3, 
              0}, {-1.65618364739931, -2.81505323267394}]}, \
{{-1.65618364739931, -2.81505323267394}, 
             Offset[{-3, 0}, {-1.65618364739931, -2.81505323267394}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5040228008910033`, -2.2211862249783216`}, 
             
             Offset[{3, 
              0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.2211862249783216`}, 
             
             Offset[{-3, 
              0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
             
             Offset[{3, 
              0}, {-1.5040228008910033`, -2.875105173039695}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
             
             Offset[{-3, 
              0}, {-1.5040228008910033`, -2.875105173039695}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3539296288670801`, -2.326001350065366}, 
             
             Offset[{3, 
              0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.326001350065366}, 
             
             Offset[{-3, 
              0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
             
             Offset[{3, 
              0}, {-1.3539296288670801`, -2.956534168031409}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
             
             Offset[{-3, 
              0}, {-1.3539296288670801`, -2.956534168031409}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2055237319284868`, -2.4020969056151844`}, 
             
             Offset[{3, 
              0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -2.4020969056151844`}, 
             
             Offset[{-3, 
              0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
             
             Offset[{3, 
              0}, {-1.2055237319284868`, -3.0030836819866935`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
             
             Offset[{-3, 
              0}, {-1.2055237319284868`, -3.0030836819866935`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}}}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAPkkMtCefFsD/IdfV+vTwv/xnfELJ
BRbAB7xyXlXJ9L8e+sPidWgVwBCEFHC+x/i/XraOVhDKFMCvKohga/T5vwJ3
/nZKLxTAcYr5DmZX+r+I96wp6ZMTwNeKs0rvRvy/L94WJwL7EsD1EDXjy3b8
v+0hzJ3yYhLAk4gSVe9t/r/AmyLOfMoRwCQq37IqhP6/smxLjOExEcBte1RW
hkz/vwZRTl45mRDAXq1R8+0CAMBixy0XTwEQwB362aDjrP+/NgSnZo7ODsD2
IJ2NQWUBwDs9JChDmQ3AdSG02kZIAMBI18rL7mYMwCT0RJJ+/ADAxsKZPrAy
C8B/A/W+/uIAwEi8eJ1m/gnAw7695uH2AMC/tZJTf8sIwNB/fMCZhwHAYspf
7VXHB8D4MMlyc/UAwPP89ZZuhwbAyT1UcBf9AMCwNFXr0xgFwMcEhf52OgLA
Fcuigh7oA8BPLab+S1sCwA/jYdO+vQLAENK81sUSA8AOCcD81Y8BwEGhpmWc
ewPAsl7Sx4liAMBXTK6IGB0EwATSKw69ef6/tcYepWmcBMB6sm8rkR38v9WM
iW8ujwXALHiMxLev+b8hjI4XmYUGwFMPeDglQve/yl3AbU6ZB8B7+MK1otX0
v/PltGkVqAjAiOvtylRq8r8ODd+pR9UJwDWoB98+A/C/HTm7ErDSCsBWhVwz
nzbrv8i9+DWYOgvAnNwTjQ==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAHvrD4nVoFcCS6nff6W3yv162jlYQ
yhTAlqT8Q44e8b8Cd/52Si8UwM7UgZ/c0fq/iPesKemTE8AsX6OQKc37vy/e
FicC+xLAqkF9zeAz/b/tIcyd8mISwLks8avLW/y/wJsiznzKEcDX+C6bMFz8
v7JsS4zhMRHAvp+TvymY/b8GUU5eOZkQwNuocXuuQgDAYsctF08BEMATWdVI
Trn+vzYEp2aOzg7AAS5RzBSgAcA7PSQoQ5kNwH3NWcvBEgHASNfKy+5mDMBB
DZlc7GAAwMbCmT6wMgvA4sgcgvGjAMBIvHidZv4JwF1rxIa/4gDAv7WSU3/L
CMBxMydgvs0AwGLKX+1VxwfA7QibYmtaAcDz/PWWbocGwCUSY3vMHADAsDRV
69MYBcDHlSa4SaYBwBXLooIe6APAHJXYkMDOAcAP42HTvr0CwF0EOFBfVgLA
DgnA/NWPAcDCCwEqyKICwLJe0seJYgDA65a5PWYQA8AE0isOvXn+vxwW6AgI
cwPAerJvK5Ed/L/7o7tEWBcEwCx4jMS3r/m/4IrUZtzoBMBTD3g4JUL3vwM7
4WA9lAXAe/jCtaLV9L9ZqETshZAGwIjr7cpUavK/wJHdX2RaB8BQju9P
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAPgEN6BvZE8BK3Cx95Nj3v5zekUvQ
PxPAdReuZuzB978SA/vTLqYSwEiJqOHrwfe/tQ9PCS8LEsAw6sul5tf+vw/h
8gBwbxHA8W24XBCn+L8e+hnTN9MQwNeO6RoxSP2/gHn/FJs5EMBpG6KJCEf9
v6QuS53gQQ/ApT2IyHliAMBIFQuR6AwOwEAWWSxibwHA673eBRTYDMBLeZ85
knf+v1GljbfCpgvABGUcvIEwAcAETntUDHUKwE3MxMGwuwDAfMza9uZACcDZ
eSaDbpsAwJ+Za3MDKAjA/kSSpoeTAMCwiafvQt4GwOVTEDyTBgDAiOU3hvOH
BcA+VZ8spIMBwLY1zNalbwTA1uhvNCuKAcAscoT6j0UDwFPGaZAx8QHA+f+A
HxoSAsA41teajCYCwGCFIIeo4ADAxDXiODW0AsAeVp18iVP/v/IQdBXEvwLA
+tCxav/p/L9HV54RIF8DwCEAnGy6f/q/M25kFs7DA8AsPmQ2ehD4v3d+VTaa
YgTAyBxRHbKp9b97vKj9UCEFwJ/0skDTSfO/guXyqOeeBcDOr9El
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6., 0.}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C14\"", "\"C15\"", "\"C16\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.90592611664227*^9},
 CellLabel->
  "Out[595]=",ExpressionUUID->"9cdeb853-9d38-4bf3-ac79-0fe4b58e7d64"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\SlopesC14-16.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926118109047*^9},
 CellLabel->
  "Out[596]=",ExpressionUUID->"a555b786-2860-47c7-b982-68ee7051ef4a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.483842181677217, 
           6.332267788392241}, {-5.483842181677217, 6.35145520112369}}], 
          
          LineBox[{{-5.483842181677217, 
           6.35145520112369}, {-5.483842181677217, 6.370281377367599}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.380228407219979, 
           6.156375565843266}, {-5.380228407219979, 6.181225944599282}}], 
          
          LineBox[{{-5.380228407219979, 
           6.181225944599282}, {-5.380228407219979, 
           6.2054737265324516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.286352047426554, 
           5.9973371984940504`}, {-5.286352047426554, 6.023066046478073}}], 
          
          LineBox[{{-5.286352047426554, 
           6.023066046478073}, {-5.286352047426554, 6.04814949160639}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.228332740694611, 
           5.9031764307698005`}, {-5.228332740694611, 5.926880423702094}}], 
          
          LineBox[{{-5.228332740694611, 
           5.926880423702094}, {-5.228332740694611, 5.950035523214047}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           5.785592932761042}, {-5.1734965151745005`, 5.80280779754565}}], 
          
          LineBox[{{-5.1734965151745005`, 
           5.80280779754565}, {-5.1734965151745005`, 
           5.8197313191215185`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.121512103387059, 
           5.703486967223862}, {-5.121512103387059, 5.722354987080129}}], 
          
          LineBox[{{-5.121512103387059, 
           5.722354987080129}, {-5.121512103387059, 5.740873587443014}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           5.621145918297111}, {-5.0720974097604925`, 5.6396789767591375`}}], 
          
          LineBox[{{-5.0720974097604925`, 
           5.6396789767591375`}, {-5.0720974097604925`, 
           5.657874801461402}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.025010372042255, 
           5.526205369277399}, {-5.025010372042255, 5.550523698210965}}], 
          
          LineBox[{{-5.025010372042255, 
           5.550523698210965}, {-5.025010372042255, 5.574264658876496}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.980041374477484, 
           5.446638613359558}, {-4.980041374477484, 5.4723918294160026`}}], 
          
          LineBox[{{-4.980041374477484, 
           5.4723918294160026`}, {-4.980041374477484, 
           5.497498434800429}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.92662358321994, 5.356218893512296}, {-4.92662358321994,
            5.3756976672670795`}}], 
          
          LineBox[{{-4.92662358321994, 
           5.3756976672670795`}, {-4.92662358321994, 5.394804256549144}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.87574337247038, 5.274931115486365}, {-4.87574337247038,
            5.291053413102918}}], 
          
          LineBox[{{-4.87574337247038, 5.291053413102918}, {-4.87574337247038,
            5.306919901026014}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.827483513108963, 
           5.17607691593067}, {-4.827483513108963, 5.200968616845535}}], 
          
          LineBox[{{-4.827483513108963, 
           5.200968616845535}, {-4.827483513108963, 5.225255739509841}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.77239942676781, 5.071643748632878}, {-4.77239942676781,
            5.093679604897293}}], 
          
          LineBox[{{-4.77239942676781, 5.093679604897293}, {-4.77239942676781,
            5.1152403332399725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.720192452293243, 
           4.977873307895476}, {-4.720192452293243, 4.99363862570167}}], 
          
          LineBox[{{-4.720192452293243, 
           4.99363862570167}, {-4.720192452293243, 5.009159250929224}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.670576785004793, 
           4.881006861233649}, {-4.670576785004793, 4.89889707406983}}], 
          
          LineBox[{{-4.670576785004793, 
           4.89889707406983}, {-4.670576785004793, 4.916472844394972}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.623307322213241, 
           4.799491238281539}, {-4.623307322213241, 4.816156779950949}}], 
          
          LineBox[{{-4.623307322213241, 
           4.816156779950949}, {-4.623307322213241, 
           4.8325491280408714`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.578172095309458, 
           4.703220123816942}, {-4.578172095309458, 4.718950131429895}}], 
          
          LineBox[{{-4.578172095309458, 
           4.718950131429895}, {-4.578172095309458, 4.734436532884893}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.528024063416046, 
           4.604814237574135}, {-4.528024063416046, 4.6258761312036505`}}], 
          
          LineBox[{{-4.528024063416046, 
           4.6258761312036505`}, {-4.528024063416046, 
           4.646503556467098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.473567500947851, 
           4.497350073609051}, {-4.473567500947851, 4.51230217964658}}], 
          
          LineBox[{{-4.473567500947851, 
           4.51230217964658}, {-4.473567500947851, 4.527034009754865}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           4.390221268237085}, {-4.4219245540939545`, 4.409523323142806}}], 
          
          LineBox[{{-4.4219245540939545`, 
           4.409523323142806}, {-4.4219245540939545`, 
           4.428459852976448}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.372818566555532, 
           4.293961911984705}, {-4.372818566555532, 4.31150936454957}}], 
          
          LineBox[{{-4.372818566555532, 
           4.31150936454957}, {-4.372818566555532, 4.328754206438605}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.326011954933506, 
           4.216711576018824}, {-4.326011954933506, 4.227552760667896}}], 
          
          LineBox[{{-4.326011954933506, 
           4.227552760667896}, {-4.326011954933506, 4.238277673430781}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.275892138786888, 
           4.112461515658199}, {-4.275892138786888, 4.130717782410805}}], 
          
          LineBox[{{-4.275892138786888, 
           4.130717782410805}, {-4.275892138786888, 4.14864672468265}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.222951251037713, 
           4.007983319529881}, {-4.222951251037713, 4.023121003676567}}], 
          
          LineBox[{{-4.222951251037713, 
           4.023121003676567}, {-4.222951251037713, 4.038032951224964}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.172673294218139, 
           3.896515735572213}, {-4.172673294218139, 3.91733697211612}}], 
          
          LineBox[{{-4.172673294218139, 
           3.91733697211612}, {-4.172673294218139, 3.9377335124395536`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.124803134014643, 
           3.8057498639594614`}, {-4.124803134014643, 3.8237898500823797`}}], 
          
          LineBox[{{-4.124803134014643, 
           3.8237898500823797`}, {-4.124803134014643, 
           3.8415101536586405`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.074701219535939, 
           3.708201385744695}, {-4.074701219535939, 3.719938538917089}}], 
          
          LineBox[{{-4.074701219535939, 
           3.719938538917089}, {-4.074701219535939, 3.731539527959118}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.026921534839552, 
           3.629623065780946}, {-4.026921534839552, 3.63746754985972}}], 
          
          LineBox[{{-4.026921534839552, 
           3.63746754985972}, {-4.026921534839552, 3.6452509766602152`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           3.5180374425816248`}, {-3.9773780413268547`, 3.530725095255669}}], 
          
          LineBox[{{-3.9773780413268547`, 
           3.530725095255669}, {-3.9773780413268547`, 
           3.543253786145549}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           3.410587003727016}, {-3.9262371908045295`, 3.4238861329709507`}}], 
          
          LineBox[{{-3.9262371908045295`, 
           3.4238861329709507`}, {-3.9262371908045295`, 
           3.4370107141743302`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           3.3066253433589923`}, {-3.8776461425773476`, 3.322504390142283}}], 
          
          LineBox[{{-3.8776461425773476`, 
           3.322504390142283}, {-3.8776461425773476`, 
           3.338135228970791}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.827799486652153, 
           3.177833393466894}, {-3.827799486652153, 3.1936623784065583`}}], 
          
          LineBox[{{-3.827799486652153, 
           3.1936623784065583`}, {-3.827799486652153, 
           3.209244705849969}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           3.087538449957183}, {-3.7770410262852683`, 3.0999135466087546`}}], 
          
          LineBox[{{-3.7770410262852683`, 
           3.0999135466087546`}, {-3.7770410262852683`, 
           3.1121373703531185`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7255676492705025`, 
           2.966693706834019}, {-3.7255676492705025`, 2.9786869800120774`}}], 
          
          LineBox[{{-3.7255676492705025`, 
           2.9786869800120774`}, {-3.7255676492705025`, 
           2.9905381175763446`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           2.8724322839183993`}, {-3.6766150586043187`, 2.883310022013918}}], 
          
          LineBox[{{-3.6766150586043187`, 
           2.883310022013918}, {-3.6766150586043187`, 
           2.8940707070540745`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           2.7562755599433504`}, {-3.6271250750319357`, 
           2.7735768687628575`}}], 
          
          LineBox[{{-3.6271250750319357`, 
           2.7735768687628575`}, {-3.6271250750319357`, 
           2.7905839260176397`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.577239779380398, 
           2.666931022778844}, {-3.577239779380398, 2.675899123478101}}], 
          
          LineBox[{{-3.577239779380398, 
           2.675899123478101}, {-3.577239779380398, 
           2.6847875116873423`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           2.568087090040097}, {-3.5271719803333474`, 2.579512383699999}}], 
          
          LineBox[{{-3.5271719803333474`, 
           2.579512383699999}, {-3.5271719803333474`, 
           2.5908086132321415`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           2.4471589242341794`}, {-3.4770227859145613`, 2.458037918692001}}], 
          
          LineBox[{{-3.4770227859145613`, 
           2.458037918692001}, {-3.4770227859145613`, 
           2.4687998331992516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           2.343637810418284}, {-3.4269594457071775`, 2.3544713359428386`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           2.3544713359428386`}, {-3.4269594457071775`, 
           2.365188752933453}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.377049578478242, 
           2.230134925593643}, {-3.377049578478242, 2.239516293141006}}], 
          
          LineBox[{{-3.377049578478242, 
           2.239516293141006}, {-3.377049578478242, 
           2.2488104679845726`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.327422124402821, 
           2.130625354779844}, {-3.327422124402821, 2.1418158527757565`}}], 
          
          LineBox[{{-3.327422124402821, 
           2.1418158527757565`}, {-3.327422124402821, 
           2.152882508109275}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           2.0210228748403845`}, {-3.2761327623308096`, 
           2.0337376280612185`}}], 
          
          LineBox[{{-3.2761327623308096`, 
           2.0337376280612185`}, {-3.2761327623308096`, 
           2.0462927439581367`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           1.9117424986494473`}, {-3.2254264836890396`, 1.918834193864078}}], 
          
          LineBox[{{-3.2254264836890396`, 
           1.918834193864078}, {-3.2254264836890396`, 
           1.9258759508763845`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.17716826024446, 
           1.8050218457388927`}, {-3.17716826024446, 1.8141196372318638`}}], 
          
          LineBox[{{-3.17716826024446, 
           1.8141196372318638`}, {-3.17716826024446, 
           1.8231354045925807`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.127705210497175, 
           1.6964377581675354`}, {-3.127705210497175, 1.7055270962181834`}}], 
          
          LineBox[{{-3.127705210497175, 
           1.7055270962181834`}, {-3.127705210497175, 
           1.7145345618104977`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.077261733718196, 
           1.5854118453788535`}, {-3.077261733718196, 1.5952319343264998`}}], 
          
          LineBox[{{-3.077261733718196, 
           1.5952319343264998`}, {-3.077261733718196, 
           1.604956526157422}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           1.480392167262926}, {-3.0276924518494375`, 1.4875804564510997`}}], 
          
          LineBox[{{-3.0276924518494375`, 
           1.4875804564510997`}, {-3.0276924518494375`, 
           1.4947174426988612`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.977298040136891, 
           1.3770810298261345`}, {-2.977298040136891, 1.3859329991636575`}}], 
          
          LineBox[{{-2.977298040136891, 
           1.3859329991636575`}, {-2.977298040136891, 
           1.3947072981726765`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.932588839908245, 
           1.269810439419048}, {-2.932588839908245, 1.2789450550144321`}}], 
          
          LineBox[{{-2.932588839908245, 
           1.2789450550144321`}, {-2.932588839908245, 
           1.2879969841470453`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.522480231534296, 
           0.3570821791360642}, {-2.522480231534296, 0.4018199704138975}}], 
          
          LineBox[{{-2.522480231534296, 
           0.4018199704138975}, {-2.522480231534296, 
           0.4446417059635793}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.380038563220422, 
           0.038524658932424495`}, {-2.380038563220422, 
           0.07819985171511581}}], 
          
          LineBox[{{-2.380038563220422, 
           0.07819985171511581}, {-2.380038563220422, 
           0.11636081008095668`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.2851211182798545`, -0.1865476497388101}, \
{-2.2851211182798545`, -0.1505180065208107}}], 
          
          LineBox[{{-2.2851211182798545`, -0.1505180065208107}, \
{-2.2851211182798545`, -0.1157414799829208}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.226506167649257, -0.3211716361483736}, \
{-2.226506167649257, -0.28719860671173586`}}], 
          
          LineBox[{{-2.226506167649257, -0.28719860671173586`}, \
{-2.226506167649257, -0.254341922221198}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1711381157832257`, -0.4526861214788581}, \
{-2.1711381157832257`, -0.41980744655324337`}}], 
          
          LineBox[{{-2.1711381157832257`, -0.41980744655324337`}, \
{-2.1711381157832257`, -0.38797545656183047`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1186760185140363`, -0.5809216281822829}, \
{-2.1186760185140363`, -0.5479457522673019}}], 
          
          LineBox[{{-2.1186760185140363`, -0.5479457522673019}, \
{-2.1186760185140363`, -0.5160226606115117}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.0688299492905053`, -0.7046949078951291}, \
{-2.0688299492905053`, -0.673758245630414}}], 
          
          LineBox[{{-2.0688299492905053`, -0.673758245630414}, \
{-2.0688299492905053`, -0.6437500098438078}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.021351319690928, -0.8200721601511878}, \
{-2.021351319690928, -0.7917301280519227}}], 
          
          LineBox[{{-2.021351319690928, -0.7917301280519227}, \
{-2.021351319690928, -0.7641692773172595}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.976025406568619, -0.9301635446725607}, \
{-1.976025406568619, -0.9027036600587955}}], 
          
          LineBox[{{-1.976025406568619, -0.9027036600587955}, \
{-1.976025406568619, -0.8759777117849763}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.9326653384575119`, -1.037257867412581}, \
{-1.9326653384575119`, -1.0098900781576479`}}], 
          
          LineBox[{{-1.9326653384575119`, -1.0098900781576479`}, \
{-1.9326653384575119`, -0.983251375593493}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8810672419769725`, -1.17153380416838}, \
{-1.8810672419769725`, -1.1416141637443067`}}], 
          
          LineBox[{{-1.8810672419769725`, -1.1416141637443067`}, \
{-1.8810672419769725`, -1.11256376379841}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8223707416388202`, -1.3219189810470608`}, \
{-1.8223707416388202`, -1.2926919387763334`}}], 
          
          LineBox[{{-1.8223707416388202`, -1.2926919387763334`}, \
{-1.8223707416388202`, -1.2642949149265543`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7758907745205157`, -1.4386030748254146`}, \
{-1.7758907745205157`, -1.4146731201527838`}}], 
          
          LineBox[{{-1.7758907745205157`, -1.4146731201527838`}, \
{-1.7758907745205157`, -1.3913024506077454`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7316070609965282`, -1.5584852939076856`}, \
{-1.7316070609965282`, -1.5317320811275723`}}], 
          
          LineBox[{{-1.7316070609965282`, -1.5317320811275723`}, \
{-1.7316070609965282`, -1.5056759929144334`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.680857774871063, -1.6928643230727762`}, \
{-1.680857774871063, -1.6669413496265966`}}], 
          
          LineBox[{{-1.680857774871063, -1.6669413496265966`}, \
{-1.680857774871063, -1.6416734315059}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.632560487956873, -1.822102297319412}, \
{-1.632560487956873, -1.796576718985574}}], 
          
          LineBox[{{-1.632560487956873, -1.796576718985574}, \
{-1.632560487956873, -1.7716865112378122`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5790774413137347`, -1.9713842665890964`}, \
{-1.5790774413137347`, -1.94475863740435}}], 
          
          LineBox[{{-1.5790774413137347`, -1.94475863740435}, \
{-1.5790774413137347`, -1.9188235850443318`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5281875999704038`, -2.110363869112681}, \
{-1.5281875999704038`, -2.0864651302831474`}}], 
          
          LineBox[{{-1.5281875999704038`, -2.0864651302831474`}, \
{-1.5281875999704038`, -2.0631242353365447`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4798745637368198`, -2.2502761747563023`}, \
{-1.4798745637368198`, -2.224815111647474}}], 
          
          LineBox[{{-1.4798745637368198`, -2.224815111647474}, \
{-1.4798745637368198`, -2.1999862510296158`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4273150021222818`, -2.40224372755166}, \
{-1.4273150021222818`, -2.3777484422840613`}}], 
          
          LineBox[{{-1.4273150021222818`, -2.3777484422840613`}, \
{-1.4273150021222818`, -2.3538388576964406`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.377381030775886, -2.5462205174792785`}, \
{-1.377381030775886, -2.5229543828125434`}}], 
          
          LineBox[{{-1.377381030775886, -2.5229543828125434`}, \
{-1.377381030775886, -2.5002172760544723`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.329822772449285, -2.686209433990561}, \
{-1.329822772449285, -2.663506896893459}}], 
          
          LineBox[{{-1.329822772449285, -2.663506896893459}, \
{-1.329822772449285, -2.641308344422615}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2789374525299622`, -2.8411602695234515`}, \
{-1.2789374525299622`, -2.8166681206051285`}}], 
          
          LineBox[{{-1.2789374525299622`, -2.8166681206051285`}, \
{-1.2789374525299622`, -2.7927615241770645`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2252283792125176`, -3.0073125404148917`}, \
{-1.2252283792125176`, -2.9838642645333464`}}], 
          
          LineBox[{{-1.2252283792125176`, -2.9838642645333464`}, \
{-1.2252283792125176`, -2.960953236802017}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.1742581157840541`, -3.1637366795773736`}, \
{-1.1742581157840541`, -3.1412100123622957`}}], 
          
          LineBox[{{-1.1742581157840541`, -3.1412100123622957`}, \
{-1.1742581157840541`, -3.1191796366143913`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.125760810882863, -3.3152863484401958`}, \
{-1.125760810882863, -3.2942324933404725`}}], 
          
          LineBox[{{-1.125760810882863, -3.2942324933404725`}, \
{-1.125760810882863, -3.2736127784361098`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.0750347908756233`, -3.480484204349799}, \
{-1.0750347908756233`, -3.4582033831068917`}}], 
          
          LineBox[{{-1.0750347908756233`, -3.4582033831068917`}, \
{-1.0750347908756233`, -3.436408196179977}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.026687762897248, -3.638827878682187}, \
{-1.026687762897248, -3.6183400185583965`}}], 
          
          LineBox[{{-1.026687762897248, -3.6183400185583965`}, \
{-1.026687762897248, -3.5982634974892544`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9765855081311018, -3.8027604786997733`}, \
{-0.9765855081311018, -3.7810171105219155`}}], 
          
          LineBox[{{-0.9765855081311018, -3.7810171105219155`}, \
{-0.9765855081311018, -3.759736472924594}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.924895304705649, -3.9788120944092733`}, \
{-0.924895304705649, -3.958308743860202}}], 
          
          LineBox[{{-0.924895304705649, -3.958308743860202}, \
{-0.924895304705649, -3.9382173483772096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8758086169295246, -4.1440955001409145`}, \
{-0.8758086169295246, -4.1229367463632105`}}], 
          
          LineBox[{{-0.8758086169295246, -4.1229367463632105`}, \
{-0.8758086169295246, -4.102216424785592}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8254778772492771, -4.3122438522655955`}, \
{-0.8254778772492771, -4.29302085628333}}], 
          
          LineBox[{{-0.8254778772492771, -4.29302085628333}, \
{-0.8254778772492771, -4.274160425245053}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7775597923865766, -4.477103807500962}, \
{-0.7775597923865766, -4.4574398347379915`}}], 
          
          LineBox[{{-0.7775597923865766, -4.4574398347379915`}, \
{-0.7775597923865766, -4.438155088680047}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7286714703974044, -4.649129038704672}, \
{-0.7286714703974044, -4.629974743058506}}], 
          
          LineBox[{{-0.7286714703974044, -4.629974743058506}, \
{-0.7286714703974044, -4.6111804496640945`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.256921585253977, 
           4.916003049440286}, {-5.256921585253977, 4.931772873949715}}], 
          
          LineBox[{{-5.256921585253977, 
           4.931772873949715}, {-5.256921585253977, 
           4.9472978670474435`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.2005387488032095`, 
           4.815197087486978}, {-5.2005387488032095`, 4.8605249775483506`}}], 
          
          LineBox[{{-5.2005387488032095`, 
           4.8605249775483506`}, {-5.2005387488032095`, 
           4.903887035076208}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.147166472619123, 
           4.802253480340173}, {-5.147166472619123, 4.831719970836755}}], 
          
          LineBox[{{-5.147166472619123, 
           4.831719970836755}, {-5.147166472619123, 4.860342982355051}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.09649951504208, 4.745043592909464}, {-5.09649951504208,
            4.758050377441397}}], 
          
          LineBox[{{-5.09649951504208, 4.758050377441397}, {-5.09649951504208,
            4.770890155423466}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.048276729473299, 
           4.680873160044332}, {-5.048276729473299, 4.697534992379946}}], 
          
          LineBox[{{-5.048276729473299, 
           4.697534992379946}, {-5.048276729473299, 4.713923751741053}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.002273086667765, 
           4.633339824757316}, {-5.002273086667765, 4.645247737537986}}], 
          
          LineBox[{{-5.002273086667765, 
           4.645247737537986}, {-5.002273086667765, 4.657015518967403}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.94768844245325, 4.555845334180664}, {-4.94768844245325,
            4.576905160617127}}], 
          
          LineBox[{{-4.94768844245325, 4.576905160617127}, {-4.94768844245325,
            4.597530603091691}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.895750762859643, 
           4.514365137053437}, {-4.895750762859643, 4.530432892793083}}], 
          
          LineBox[{{-4.895750762859643, 
           4.530432892793083}, {-4.895750762859643, 4.54624655312104}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.846540574896795, 
           4.4099692173223595`}, {-4.846540574896795, 4.4391322339807}}], 
          
          LineBox[{{-4.846540574896795, 4.4391322339807}, {-4.846540574896795,
            4.467468813585732}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           4.32273455616702}, {-4.7904256789098545`, 4.337108285370662}}], 
          
          LineBox[{{-4.7904256789098545`, 
           4.337108285370662}, {-4.7904256789098545`, 4.3512783346659}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.745892143749627, 
           4.272478179597468}, {-4.745892143749627, 4.274664963432068}}], 
          
          LineBox[{{-4.745892143749627, 
           4.274664963432068}, {-4.745892143749627, 4.276846975675669}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.703378855771098, 
           4.201013954254975}, {-4.703378855771098, 4.214106768501999}}], 
          LineBox[{{-4.703378855771098, 
           4.214106768501999}, {-4.703378855771098, 4.227030373996963}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.646735106032223, 
           4.106654030302789}, {-4.646735106032223, 4.126755164224526}}], 
          
          LineBox[{{-4.646735106032223, 
           4.126755164224526}, {-4.646735106032223, 4.146460191676187}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.592991950938105, 
           4.015205706678675}, {-4.592991950938105, 4.03752588133449}}], 
          
          LineBox[{{-4.592991950938105, 
           4.03752588133449}, {-4.592991950938105, 4.059358723353405}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.5491755160613705`, 
           3.971296098879905}, {-4.5491755160613705`, 3.981342277488459}}], 
          
          LineBox[{{-4.5491755160613705`, 
           3.981342277488459}, {-4.5491755160613705`, 
           3.991288533401589}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.500425063167319, 
           3.87366719851485}, {-4.500425063167319, 3.8879670619006133`}}], 
          
          LineBox[{{-4.500425063167319, 
           3.8879670619006133`}, {-4.500425063167319, 3.90206531875241}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.4474126107277066`, 
           3.78483370301672}, {-4.4474126107277066`, 3.8016237559825496`}}], 
          
          LineBox[{{-4.4474126107277066`, 
           3.8016237559825496`}, {-4.4474126107277066`, 
           3.8181365518258343`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.397070109545044, 
           3.6882509219745745`}, {-4.397070109545044, 3.701340363605945}}], 
          
          LineBox[{{-4.397070109545044, 
           3.701340363605945}, {-4.397070109545044, 
           3.7142606830861493`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.349141399333698, 
           3.614223127310186}, {-4.349141399333698, 3.61959429161574}}], 
          
          LineBox[{{-4.349141399333698, 
           3.61959429161574}, {-4.349141399333698, 3.6249367605741036`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.297879181821557, 
           3.524356138838757}, {-4.297879181821557, 3.5405105261705385`}}], 
          
          LineBox[{{-4.297879181821557, 
           3.5405105261705385`}, {-4.297879181821557, 
           3.556408092560988}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.243792424715041, 
           3.4258026676111086`}, {-4.243792424715041, 3.4426086791015535`}}], 
          
          LineBox[{{-4.243792424715041, 
           3.4426086791015535`}, {-4.243792424715041, 
           3.4591369105150376`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.192482121267007, 
           3.318620404485464}, {-4.192482121267007, 3.329492401556576}}], 
          
          LineBox[{{-4.192482121267007, 
           3.329492401556576}, {-4.192482121267007, 
           3.3402474684327395`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.143677057603073, 
           3.262419042119993}, {-4.143677057603073, 3.272496861347926}}], 
          
          LineBox[{{-4.143677057603073, 
           3.272496861347926}, {-4.143677057603073, 
           3.2824741306172616`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.097143880912867, 
           3.154993611608522}, {-4.097143880912867, 3.1641709515717986`}}], 
          
          LineBox[{{-4.097143880912867, 
           3.1641709515717986`}, {-4.097143880912867, 
           3.1732648333103417`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.048375288040937, 
           3.06963537597687}, {-4.048375288040937, 3.0882070283509946`}}], 
          
          LineBox[{{-4.048375288040937, 
           3.0882070283509946`}, {-4.048375288040937, 
           3.106440053760237}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.997716015667319, 
           2.9679921411027066`}, {-3.997716015667319, 2.9846472424869446`}}], 
          
          LineBox[{{-3.997716015667319, 
           2.9846472424869446`}, {-3.997716015667319, 
           3.0010294896793988`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9456183557485507`, 
           2.8732844648130293`}, {-3.9456183557485507`, 2.881390956505016}}], 
          
          LineBox[{{-3.9456183557485507`, 
           2.881390956505016}, {-3.9456183557485507`, 2.88943226107421}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.896038528511996, 
           2.7794080245605435`}, {-3.896038528511996, 2.791951766145271}}], 
          
          LineBox[{{-3.896038528511996, 
           2.791951766145271}, {-3.896038528511996, 
           2.8043401095394573`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.8488587655549606`, 
           2.650330485621626}, {-3.8488587655549606`, 2.6650851655324947`}}], 
          
          LineBox[{{-3.8488587655549606`, 
           2.6650851655324947`}, {-3.8488587655549606`, 
           2.6796253064823192`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7970479452732633`, 
           2.5703264491403686`}, {-3.7970479452732633`, 2.58216914440067}}], 
          
          LineBox[{{-3.7970479452732633`, 
           2.58216914440067}, {-3.7970479452732633`, 
           2.5938732301392484`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7445609736580776`, 
           2.460474793202221}, {-3.7445609736580776`, 2.4785806470667286`}}], 
          
          LineBox[{{-3.7445609736580776`, 
           2.4785806470667286`}, {-3.7445609736580776`, 
           2.496364500440907}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6946925590696376`, 
           2.3614714448759906`}, {-3.6946925590696376`, 2.372429007740879}}], 
          
          LineBox[{{-3.6946925590696376`, 
           2.372429007740879}, {-3.6946925590696376`, 
           2.383267802653664}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.647193798405784, 
           2.2425409025142056`}, {-3.647193798405784, 2.2532390664126636`}}], 
          
          LineBox[{{-3.647193798405784, 
           2.2532390664126636`}, {-3.647193798405784, 
           2.263823989995185}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5963690136318585`, 
           2.1699653211905865`}, {-3.5963690136318585`, 
           2.1816444709328318`}}], 
          
          LineBox[{{-3.5963690136318585`, 
           2.1816444709328318`}, {-3.5963690136318585`, 
           2.1931887913137893`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5453141380980635`, 
           2.0466416664455895`}, {-3.5453141380980635`, 
           2.0597557349399183`}}], 
          
          LineBox[{{-3.5453141380980635`, 
           2.0597557349399183`}, {-3.5453141380980635`, 
           2.072700048419323}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4967816516117667`, 
           1.9536979571994584`}, {-3.4967816516117667`, 
           1.9626877519875516`}}], 
          
          LineBox[{{-3.4967816516117667`, 
           1.9626877519875516`}, {-3.4967816516117667`, 
           1.9715974498852997`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.445744518368156, 
           1.8335456909158896`}, {-3.445744518368156, 1.8394591696848466`}}], 
          
          LineBox[{{-3.445744518368156, 
           1.8394591696848466`}, {-3.445744518368156, 
           1.8453378846966828`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.3949116789514067`, 
           1.7356299395333323`}, {-3.3949116789514067`, 
           1.7509946261346025`}}], 
          
          LineBox[{{-3.3949116789514067`, 
           1.7509946261346025`}, {-3.3949116789514067`, 
           1.766126807014293}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.3465387336268324`, 
           1.6291388147978767`}, {-3.3465387336268324`, 
           1.6362905135963037`}}], 
          
          LineBox[{{-3.3465387336268324`, 
           1.6362905135963037`}, {-3.3465387336268324`, 
           1.6433914285746969`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2963410320765485`, 
           1.5273462871967087`}, {-3.2963410320765485`, 1.536756506953246}}], 
          
          LineBox[{{-3.2963410320765485`, 
           1.536756506953246}, {-3.2963410320765485`, 
           1.546078999366166}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.244625779142534, 
           1.4107655645557113`}, {-3.244625779142534, 1.4221219798033184`}}], 
          
          LineBox[{{-3.244625779142534, 
           1.4221219798033184`}, {-3.244625779142534, 
           1.433350873713789}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.195454498404754, 
           1.295424300319013}, {-3.195454498404754, 1.30745846561469}}], 
          
          LineBox[{{-3.195454498404754, 
           1.30745846561469}, {-3.195454498404754, 1.3193495301675437`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.1468430769836333`, 
           1.206541189930656}, {-3.1468430769836333`, 1.2167053849024954`}}], 
          
          LineBox[{{-3.1468430769836333`, 
           1.2167053849024954`}, {-3.1468430769836333`, 
           1.2267673076580339`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.097134772347408, 
           1.0808281008819631`}, {-3.097134772347408, 1.0896143053557197`}}], 
          
          LineBox[{{-3.097134772347408, 
           1.0896143053557197`}, {-3.097134772347408, 
           1.0983239843211772`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.0465953406784982`, 
           0.9790299289099424}, {-3.0465953406784982`, 0.9892645177329515}}], 
          
          LineBox[{{-3.0465953406784982`, 
           0.9892645177329515}, {-3.0465953406784982`, 
           0.9993954200405409}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.994268823040654, 
           0.861207107756213}, {-2.994268823040654, 0.8711185937196824}}], 
          
          LineBox[{{-2.994268823040654, 
           0.8711185937196824}, {-2.994268823040654, 
           0.8809328054726075}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.9453650008726933`, 
           0.7497507159590878}, {-2.9453650008726933`, 0.7604573918143119}}], 
          
          LineBox[{{-2.9453650008726933`, 
           0.7604573918143119}, {-2.9453650008726933`, 
           0.7710506480369244}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.917432257064329, 
           0.7045413987340081}, {-2.917432257064329, 0.7135268056864034}}], 
          
          LineBox[{{-2.917432257064329, 
           0.7135268056864034}, {-2.917432257064329, 
           0.7224321935710046}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.6444443836852294`, 
           0.07611061484277461}, {-2.6444443836852294`, 0.1255451058978268}}], 
          
          LineBox[{{-2.6444443836852294`, 
           0.1255451058978268}, {-2.6444443836852294`, 
           0.17265051320451064`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.4487245335749988`, -0.3537885673820241}, \
{-2.4487245335749988`, -0.31376134455524324`}}], 
          
          LineBox[{{-2.4487245335749988`, -0.31376134455524324`}, \
{-2.4487245335749988`, -0.27527482788118784`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.347387847945706, -0.586313981672702}, \
{-2.347387847945706, -0.5455259750436788}}], 
          
          LineBox[{{-2.347387847945706, -0.5455259750436788}, \
{-2.347387847945706, -0.5063366363537956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.2553841482219026`, -0.7911307177678641}, \
{-2.2553841482219026`, -0.7578069820377714}}], 
          
          LineBox[{{-2.2553841482219026`, -0.7578069820377714}, \
{-2.2553841482219026`, -0.7255579991354887}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1984389311930306`, -0.9232708899007307}, \
{-2.1984389311930306`, -0.8904320734581772}}], 
          
          LineBox[{{-2.1984389311930306`, -0.8904320734581772}, \
{-2.1984389311930306`, -0.8586374458051824}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -1.0490395894914601`}, \
{-2.144562997373256, -1.017950640374717}}], 
          
          LineBox[{{-2.144562997373256, -1.017950640374717}, \
{-2.144562997373256, -0.9877991428556102}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -1.172329995051642}, \
{-2.0934424039470523`, -1.141772001381916}}], 
          
          LineBox[{{-2.0934424039470523`, -1.141772001381916}, \
{-2.0934424039470523`, -1.1121201764121216`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0448088291688524`, -1.2887416943505956`}, \
{-2.0448088291688524`, -1.2586510928646328`}}], 
          
          LineBox[{{-2.0448088291688524`, -1.2586510928646328`}, \
{-2.0448088291688524`, -1.229439548700503}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.998431547349378, -1.3978677974815459`}, \
{-1.998431547349378, -1.3709847631615433`}}], 
          
          LineBox[{{-1.998431547349378, -1.3709847631615433`}, \
{-1.998431547349378, -1.344805546887227}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.9434261704597346`, -1.5327689225789798`}, \
{-1.9434261704597346`, -1.5022005217201047`}}], 
          
          LineBox[{{-1.9434261704597346`, -1.5022005217201047`}, \
{-1.9434261704597346`, -1.4725388977839176`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8911076856443865`, -1.6565801648378016`}, \
{-1.8911076856443865`, -1.6312397213145609`}}], 
          
          LineBox[{{-1.8911076856443865`, -1.6312397213145609`}, \
{-1.8911076856443865`, -1.606525577833347}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8415558697159746`, -1.7819288294988815`}, \
{-1.8415558697159746`, -1.7529841518188212`}}], 
          
          LineBox[{{-1.8415558697159746`, -1.7529841518188212`}, \
{-1.8415558697159746`, -1.7248537546657674`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.794195067044452, -1.8940754116843914`}, \
{-1.794195067044452, -1.870385842695426}}], 
          
          LineBox[{{-1.794195067044452, -1.870385842695426}, \
{-1.794195067044452, -1.8472445070192742`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.749112569203864, -2.0104492879613396`}, \
{-1.749112569203864, -1.9835291014272236`}}], 
          
          LineBox[{{-1.749112569203864, -1.9835291014272236`}, \
{-1.749112569203864, -1.9573146542040045`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.6974896181121244`, -2.1411883922896506`}, \
{-1.6974896181121244`, -2.1157815133092766`}}], 
          
          LineBox[{{-1.6974896181121244`, -2.1157815133092766`}, \
{-1.6974896181121244`, -2.091004182011396}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.6484017660376873`, -2.265309130019623}, \
{-1.6484017660376873`, -2.2416954306510077`}}], 
          
          LineBox[{{-1.6484017660376873`, -2.2416954306510077`}, \
{-1.6484017660376873`, -2.2186264988322923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.594088397426578, -2.4094258484537985`}, \
{-1.594088397426578, -2.3821952795665817`}}], 
          
          LineBox[{{-1.594088397426578, -2.3821952795665817`}, \
{-1.594088397426578, -2.3556866005133315`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5424473593467354`, -2.540129667888773}, \
{-1.5424473593467354`, -2.518298251610649}}], 
          
          LineBox[{{-1.5424473593467354`, -2.518298251610649}, \
{-1.5424473593467354`, -2.4969332810289027`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.493457846130768, -2.673936471451916}, \
{-1.493457846130768, -2.6496759884302428`}}], 
          
          LineBox[{{-1.493457846130768, -2.6496759884302428`}, \
{-1.493457846130768, -2.625990162503444}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4466528065688393`, -2.795845163727085}, \
{-1.4466528065688393`, -2.7755174902385504`}}], 
          
          LineBox[{{-1.4466528065688393`, -2.7755174902385504`}, \
{-1.4466528065688393`, -2.755594812113655}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4020363206488669`, -2.9199103460237303`}, \
{-1.4020363206488669`, -2.8971049150224353`}}], 
          
          LineBox[{{-1.4020363206488669`, -2.8971049150224353`}, \
{-1.4020363206488669`, -2.8748079964074327`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.3474454533915494`, -3.072333265669537}, \
{-1.3474454533915494`, -3.049007775398376}}], 
          
          LineBox[{{-1.3474454533915494`, -3.049007775398376}, \
{-1.3474454533915494`, -3.0262139850199903`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2955821719692076`, -3.2123903316052367`}, \
{-1.2955821719692076`, -3.1927638426063156`}}], 
          
          LineBox[{{-1.2955821719692076`, -3.1927638426063156`}, \
{-1.2955821719692076`, -3.173515149759361}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.24636706214148, -3.353322140953836}, \
{-1.24636706214148, -3.3313639936365993`}}], 
          
          LineBox[{{-1.24636706214148, -3.3313639936365993`}, \
{-1.24636706214148, -3.3098776648422286`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1943354736944491`, -3.50342095120204}, \
{-1.1943354736944491`, -3.482729759468762}}], 
          
          LineBox[{{-1.1943354736944491`, -3.482729759468762}, \
{-1.1943354736944491`, -3.462458028665764}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1448783782845262`, -3.646285597633047}, \
{-1.1448783782845262`, -3.6259761951670617`}}], 
          
          LineBox[{{-1.1448783782845262`, -3.6259761951670617`}, \
{-1.1448783782845262`, -3.606071067567741}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0977528619957602`, -3.7854671909925734`}, \
{-1.0977528619957602`, -3.764891292202793}}], 
          
          LineBox[{{-1.0977528619957602`, -3.764891292202793}, \
{-1.0977528619957602`, -3.7447302395328927`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0483930806633872`, -3.9333489859748356`}, \
{-1.0483930806633872`, -3.9136393311364137`}}], 
          
          LineBox[{{-1.0483930806633872`, -3.9136393311364137`}, \
{-1.0483930806633872`, -3.8943106500256346`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9971493792545362, -4.089249139307863}, \
{-0.9971493792545362, -4.070020577676463}}], 
          
          LineBox[{{-0.9971493792545362, -4.070020577676463}, \
{-0.9971493792545362, -4.051154788991994}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9484045818214244, -4.2362782724921075`}, \
{-0.9484045818214244, -4.217414749894499}}], 
          
          LineBox[{{-0.9484045818214244, -4.217414749894499}, \
{-0.9484045818214244, -4.198900481776334}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.256921585253977, 
           3.5397518956839704`}, {-5.256921585253977, 3.604132094984709}}], 
          
          LineBox[{{-5.256921585253977, 
           3.604132094984709}, {-5.256921585253977, 
           3.6646170002438314`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.2005387488032095`, 
           3.6048786640720745`}, {-5.2005387488032095`, 3.640140914690889}}], 
          
          LineBox[{{-5.2005387488032095`, 
           3.640140914690889}, {-5.2005387488032095`, 
           3.6742019754307154`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.147166472619123, 
           3.581781543137103}, {-5.147166472619123, 3.5893909934635593`}}], 
          
          LineBox[{{-5.147166472619123, 
           3.5893909934635593`}, {-5.147166472619123, 
           3.596942977070691}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.09649951504208, 
           3.5120668383168407`}, {-5.09649951504208, 3.521193737759251}}], 
          
          LineBox[{{-5.09649951504208, 3.521193737759251}, {-5.09649951504208,
            3.530238089742752}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.048276729473299, 
           3.5573057090810285`}, {-5.048276729473299, 3.5591532930179586`}}], 
          
          LineBox[{{-5.048276729473299, 
           3.5591532930179586`}, {-5.048276729473299, 
           3.5609974696827384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.002273086667765, 
           3.4110281599282755`}, {-5.002273086667765, 3.415090054669025}}], 
          
          LineBox[{{-5.002273086667765, 
           3.415090054669025}, {-5.002273086667765, 
           3.4191355171445204`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.94768844245325, 3.398002942217051}, {-4.94768844245325,
            3.439562045699913}}], 
          
          LineBox[{{-4.94768844245325, 3.439562045699913}, {-4.94768844245325,
            3.4794626852181265`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.895750762859643, 
           3.373631699395793}, {-4.895750762859643, 3.379342219894325}}], 
          
          LineBox[{{-4.895750762859643, 
           3.379342219894325}, {-4.895750762859643, 
           3.3850203154243257`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.846540574896795, 
           3.3059669777760763`}, {-4.846540574896795, 3.347204303535406}}], 
          
          LineBox[{{-4.846540574896795, 
           3.347204303535406}, {-4.846540574896795, 3.386808246324671}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           3.224790337620717}, {-4.7904256789098545`, 3.243782630682914}}], 
          
          LineBox[{{-4.7904256789098545`, 
           3.243782630682914}, {-4.7904256789098545`, 
           3.262420929273909}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.745892143749627, 
           3.196364669304279}, {-4.745892143749627, 3.206201861889019}}], 
          
          LineBox[{{-4.745892143749627, 
           3.206201861889019}, {-4.745892143749627, 3.215943226033385}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.703378855771098, 
           3.1041058541146422`}, {-4.703378855771098, 3.148617869222933}}], 
          
          LineBox[{{-4.703378855771098, 
           3.148617869222933}, {-4.703378855771098, 
           3.1912327119454016`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.646735106032223, 
           3.0712169779794642`}, {-4.646735106032223, 3.08322421431034}}], 
          
          LineBox[{{-4.646735106032223, 
           3.08322421431034}, {-4.646735106032223, 3.0950889858341974`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.591895738572719, 
           3.020347010839881}, {-4.591895738572719, 3.037808694406261}}], 
          
          LineBox[{{-4.591895738572719, 
           3.037808694406261}, {-4.591895738572719, 
           3.0549706930981637`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.552199066800568, 
           2.963656587130923}, {-4.552199066800568, 2.9653204133323903`}}], 
          
          LineBox[{{-4.552199066800568, 
           2.9653204133323903`}, {-4.552199066800568, 
           2.966981475813942}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.402042555761872, 
           2.72244068066137}, {-4.402042555761872, 2.754136987931702}}], 
          
          LineBox[{{-4.402042555761872, 
           2.754136987931702}, {-4.402042555761872, 
           2.7848594282685513`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.2944436118375116`, 
           2.577286284783282}, {-4.2944436118375116`, 2.602916224742463}}], 
          
          LineBox[{{-4.2944436118375116`, 
           2.602916224742463}, {-4.2944436118375116`, 
           2.6279056529714993`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.19730843655865, 
           2.4179748591073955`}, {-4.19730843655865, 2.441782594800428}}], 
          
          LineBox[{{-4.19730843655865, 2.441782594800428}, {-4.19730843655865,
            2.465036677887166}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.137427702804738, 
           2.315959332545386}, {-4.137427702804738, 2.343671380808747}}], 
          
          LineBox[{{-4.137427702804738, 
           2.343671380808747}, {-4.137427702804738, 
           2.3706361339974746`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.053837356848126, 
           2.165842421846394}, {-4.053837356848126, 2.1909513981672397`}}], 
          
          LineBox[{{-4.053837356848126, 
           2.1909513981672397`}, {-4.053837356848126, 
           2.2154453255248745`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.001756736202332, 
           2.084903073568404}, {-4.001756736202332, 2.1095704565380244`}}], 
          
          LineBox[{{-4.001756736202332, 
           2.1095704565380244`}, {-4.001756736202332, 
           2.1336439793150426`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9522551105228425`, 
           2.005135088937175}, {-3.9522551105228425`, 2.0244467143964133`}}], 
          
          LineBox[{{-3.9522551105228425`, 
           2.0244467143964133`}, {-3.9522551105228425`, 
           2.043392455641289}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9050891681813837`, 
           1.9127673133692735`}, {-3.9050891681813837`, 
           1.9290771163444962`}}], 
          
          LineBox[{{-3.9050891681813837`, 
           1.9290771163444962`}, {-3.9050891681813837`, 
           1.9451251729689751`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8491968474870055`, 
           1.7955157097387522`}, {-3.8491968474870055`, 
           1.8231843008970643`}}], 
          
          LineBox[{{-3.8491968474870055`, 
           1.8231843008970643`}, {-3.8491968474870055`, 
           1.8501079075449622`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7960766508869286`, 
           1.7140577458013044`}, {-3.7960766508869286`, 
           1.7281837247729812`}}], 
          
          LineBox[{{-3.7960766508869286`, 
           1.7281837247729812`}, {-3.7960766508869286`, 
           1.7421129367626473`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.745806254138991, 
           1.60288585829783}, {-3.745806254138991, 1.6275611956688882`}}], 
          
          LineBox[{{-3.745806254138991, 
           1.6275611956688882`}, {-3.745806254138991, 
           1.6516422943806672`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.697789438310754, 
           1.5183357477190889`}, {-3.697789438310754, 1.5326306367790377`}}], 
          
          LineBox[{{-3.697789438310754, 
           1.5326306367790377`}, {-3.697789438310754, 1.54672405855588}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.652113025280155, 
           1.4175354154827882`}, {-3.652113025280155, 1.4386375294085572`}}], 
          
          LineBox[{{-3.652113025280155, 
           1.4386375294085572`}, {-3.652113025280155, 
           1.4593035311623632`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.5998413776538905`, 
           1.3163326023494604`}, {-3.5998413776538905`, 
           1.3346113193107039`}}], 
          
          LineBox[{{-3.5998413776538905`, 
           1.3346113193107039`}, {-3.5998413776538905`, 
           1.3525619134703617`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.550167336133954, 
           1.2025685185474397`}, {-3.550167336133954, 1.2273754157105985`}}], 
          
          LineBox[{{-3.550167336133954, 
           1.2273754157105985`}, {-3.550167336133954, 1.25158179759843}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.495239238732143, 
           1.0945094362283978`}, {-3.495239238732143, 1.1177323894276834`}}], 
          
          LineBox[{{-3.495239238732143, 
           1.1177323894276834`}, {-3.495239238732143, 
           1.1404282544651851`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4430427535118717`, 
           0.9886915924450497}, {-3.4430427535118717`, 1.0072725744337234`}}], 
          
          LineBox[{{-3.4430427535118717`, 
           1.0072725744337234`}, {-3.4430427535118717`, 
           1.0255145922437388`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.393553721612056, 
           0.8814775491511848}, {-3.393553721612056, 0.9016734345226094}}], 
          
          LineBox[{{-3.393553721612056, 
           0.9016734345226094}, {-3.393553721612056, 
           0.9214695073561545}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3462929219035455`, 
           0.7795802661389616}, {-3.3462929219035455`, 0.7961132157303615}}], 
          
          LineBox[{{-3.3462929219035455`, 
           0.7961132157303615}, {-3.3462929219035455`, 
           0.8123772665638503}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3012624883237294`, 
           0.6777420451567227}, {-3.3012624883237294`, 0.6951574097964703}}], 
          
          LineBox[{{-3.3012624883237294`, 
           0.6951574097964703}, {-3.3012624883237294`, 0.7122746638104}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.246189753861999, 
           0.5573164232822041}, {-3.246189753861999, 0.576420727612332}}], 
          
          LineBox[{{-3.246189753861999, 
           0.576420727612332}, {-3.246189753861999, 0.595166888884141}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.193891750599751, 
           0.4432901143363579}, {-3.193891750599751, 0.4606255483882618}}], 
          
          LineBox[{{-3.193891750599751, 
           0.4606255483882618}, {-3.193891750599751, 
           0.4776655788442987}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.144285378030157, 
           0.33455471793664765`}, {-3.144285378030157, 
           0.35362856407077714`}}], 
          
          LineBox[{{-3.144285378030157, 
           0.35362856407077714`}, {-3.144285378030157, 
           0.3723453975814112}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.0918603937501348`, 
           0.21715802265682782`}, {-3.0918603937501348`, 
           0.2331807279571788}}], 
          
          LineBox[{{-3.0918603937501348`, 
           0.2331807279571788}, {-3.0918603937501348`, 
           0.24895074952873233`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.0420479410377324`, 
           0.10835647877806767`}, {-3.0420479410377324`, 
           0.1243678383225542}}], 
          
          LineBox[{{-3.0420479410377324`, 
           0.1243678383225542}, {-3.0420479410377324`, 
           0.1401268690542818}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.9911660280620147`, 
           0.004465355551937933}, {-2.9911660280620147`, 
           0.02043618558319995}}], 
          
          LineBox[{{-2.9911660280620147`, 
           0.02043618558319995}, {-2.9911660280620147`, 
           0.03615595263421664}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.944918614078745, -0.09427371024669369}, \
{-2.944918614078745, -0.07776176840828024}}], 
          
          LineBox[{{-2.944918614078745, -0.07776176840828024}, \
{-2.944918614078745, -0.061518047932611016`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.8965392040719284`, -0.19088384047981877`}, \
{-2.8965392040719284`, -0.17687431197411782`}}], 
          
          LineBox[{{-2.8965392040719284`, -0.17687431197411782`}, \
{-2.8965392040719284`, -0.16305834181813994`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.8466335915245713`, -0.2955991913719619}, \
{-2.8466335915245713`, -0.28399385998866317`}}], 
          
          LineBox[{{-2.8466335915245713`, -0.28399385998866317`}, \
{-2.8466335915245713`, -0.272521668664537}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.799104911673882, -0.39463232495264555`}, \
{-2.799104911673882, -0.38263824026423976`}}], 
          
          LineBox[{{-2.799104911673882, -0.38263824026423976`}, \
{-2.799104911673882, -0.37078631031137516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.750482761099594, -0.5066619887394903}, \
{-2.750482761099594, -0.4939606484306892}}], 
          
          LineBox[{{-2.750482761099594, -0.4939606484306892}, \
{-2.750482761099594, -0.4814186109231737}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.698044485612837, -0.6221875631985151}, \
{-2.698044485612837, -0.6105190836144838}}], 
          
          LineBox[{{-2.698044485612837, -0.6105190836144838}, \
{-2.698044485612837, -0.5989851885588231}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.6457065546811838`, -0.7402493497119773}, \
{-2.6457065546811838`, -0.7284007772341169}}], 
          
          LineBox[{{-2.6457065546811838`, -0.7284007772341169}, \
{-2.6457065546811838`, -0.7166909510842783}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.598812388273519, -0.8427042378193516}, \
{-2.598812388273519, -0.8297836400003847}}], 
          
          LineBox[{{-2.598812388273519, -0.8297836400003847}, \
{-2.598812388273519, -0.8170278567897532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.4487245335749988`, -1.1868442883790267`}, \
{-2.4487245335749988`, -1.1470966873806152`}}], 
          
          LineBox[{{-2.4487245335749988`, -1.1470966873806152`}, \
{-2.4487245335749988`, -1.108868747684773}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.347387847945706, -1.4104179459097763`}, \
{-2.347387847945706, -1.3712456241601982`}}], 
          
          LineBox[{{-2.347387847945706, -1.3712456241601982`}, \
{-2.347387847945706, -1.3335501051206886`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.2553841482219026`, -1.610515174160019}, \
{-2.2553841482219026`, -1.5792124174468585`}}], 
          
          LineBox[{{-2.2553841482219026`, -1.5792124174468585`}, \
{-2.2553841482219026`, -1.548859854845954}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.1984389311930306`, -1.7410489146133443`}, \
{-2.1984389311930306`, -1.708857470597033}}], 
          
          LineBox[{{-2.1984389311930306`, -1.708857470597033}, \
{-2.1984389311930306`, -1.677670077788973}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -1.8610113360521403`}, \
{-2.144562997373256, -1.8302666228349236`}}], 
          
          LineBox[{{-2.144562997373256, -1.8302666228349236`}, \
{-2.144562997373256, -1.8004390207716026`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -1.978149705351994}, \
{-2.0934424039470523`, -1.9488614583460429`}}], 
          
          LineBox[{{-2.0934424039470523`, -1.9488614583460429`}, \
{-2.0934424039470523`, -1.9204066603716774`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0448088291688524`, -2.09175619414602}, \
{-2.0448088291688524`, -2.06419560541432}}], 
          
          LineBox[{{-2.0448088291688524`, -2.06419560541432}, \
{-2.0448088291688524`, -2.037374273906816}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.998431547349378, -2.196856578896347}, \
{-1.998431547349378, -2.1705224741650078`}}], 
          
          LineBox[{{-1.998431547349378, -2.1705224741650078`}, \
{-1.998431547349378, -2.1448640978500944`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.9434261704597346`, -2.325426564354806}, \
{-1.9434261704597346`, -2.2972225240523065`}}], 
          
          LineBox[{{-1.9434261704597346`, -2.2972225240523065`}, \
{-1.9434261704597346`, -2.2697921801533427`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8911076856443865`, -2.4433123454615595`}, \
{-1.8911076856443865`, -2.418802715616315}}], 
          
          LineBox[{{-1.8911076856443865`, -2.418802715616315}, \
{-1.8911076856443865`, -2.3948794644528713`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8415558697159746`, -2.564507256997667}, \
{-1.8415558697159746`, -2.5373772979000555`}}], 
          
          LineBox[{{-1.8415558697159746`, -2.5373772979000555`}, \
{-1.8415558697159746`, -2.5109639739927583`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.794195067044452, -2.671614334748812}, \
{-1.794195067044452, -2.648676255425465}}], 
          
          LineBox[{{-1.794195067044452, -2.648676255425465}, \
{-1.794195067044452, -2.6262525547736644`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.749112569203864, -2.7815190151207516`}, \
{-1.749112569203864, -2.7576111670841836`}}], 
          
          LineBox[{{-1.749112569203864, -2.7576111670841836`}, \
{-1.749112569203864, -2.7342615833176724`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.6974896181121244`, -2.903570177197153}, \
{-1.6974896181121244`, -2.8797610949307213`}}], 
          
          LineBox[{{-1.6974896181121244`, -2.8797610949307213`}, \
{-1.6974896181121244`, -2.8565057271763825`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.6484017660376873`, -3.0234970987971503`}, \
{-1.6484017660376873`, -3.000491274927711}}], 
          
          LineBox[{{-1.6484017660376873`, -3.000491274927711}, \
{-1.6484017660376873`, -2.9780028383746417`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.594088397426578, -3.156063992896018}, \
{-1.594088397426578, -3.131986098160082}}], 
          
          LineBox[{{-1.594088397426578, -3.131986098160082}, \
{-1.594088397426578, -3.1084743436810984`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5424473593467354`, -3.2771672179788895`}, \
{-1.5424473593467354`, -3.2565646895033864`}}], 
          
          LineBox[{{-1.5424473593467354`, -3.2565646895033864`}, \
{-1.5424473593467354`, -3.2363780708282426`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.493457846130768, -3.4026682872224967`}, \
{-1.493457846130768, -3.379834623390148}}], 
          
          LineBox[{{-1.493457846130768, -3.379834623390148}, \
{-1.493457846130768, -3.3575107177672}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4466528065688393`, -3.5158272349088477`}, \
{-1.4466528065688393`, -3.496416983781508}}], 
          
          LineBox[{{-1.4466528065688393`, -3.496416983781508}, \
{-1.4466528065688393`, -3.477376327948348}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4020363206488669`, -3.627818212178844}, \
{-1.4020363206488669`, -3.60796773090851}}], 
          
          LineBox[{{-1.4020363206488669`, -3.60796773090851}, \
{-1.4020363206488669`, -3.5885036337742022`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.3474454533915494`, -3.769242478142074}, \
{-1.3474454533915494`, -3.7471234749399778`}}], 
          
          LineBox[{{-1.3474454533915494`, -3.7471234749399778`}, \
{-1.3474454533915494`, -3.7254831531776773`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2955821719692076`, -3.8985074205778676`}, \
{-1.2955821719692076`, -3.880453481101475}}], 
          
          LineBox[{{-1.2955821719692076`, -3.880453481101475}, \
{-1.2955821719692076`, -3.8627197145158987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.24636706214148, -4.028475739564562}, \
{-1.24636706214148, -4.008133767414499}}], 
          
          LineBox[{{-1.24636706214148, -4.008133767414499}, \
{-1.24636706214148, -3.988197354918023}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1943354736944491`, -4.164891256804122}, \
{-1.1943354736944491`, -4.146653409361832}}], 
          
          LineBox[{{-1.1943354736944491`, -4.146653409361832}, \
{-1.1943354736944491`, -4.1287422321298095`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1448783782845262`, -4.292026310051753}, \
{-1.1448783782845262`, -4.273691469009357}}], 
          
          LineBox[{{-1.1448783782845262`, -4.273691469009357}, \
{-1.1448783782845262`, -4.25568675069659}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0977528619957602`, -4.417271085963078}, \
{-1.0977528619957602`, -4.399975925491824}}], 
          
          LineBox[{{-1.0977528619957602`, -4.399975925491824}, \
{-1.0977528619957602`, -4.3829748092588945`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0483930806633872`, -4.549947375319736}, \
{-1.0483930806633872`, -4.531731564091424}}], 
          
          LineBox[{{-1.0483930806633872`, -4.531731564091424}, \
{-1.0483930806633872`, -4.513841641171787}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9971493792545362, -4.690243093634208}, \
{-0.9971493792545362, -4.671514106896482}}], 
          
          LineBox[{{-0.9971493792545362, -4.671514106896482}, \
{-0.9971493792545362, -4.653129455923153}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9484045818214244, -4.815824378984583}, \
{-0.9484045818214244, -4.799067653114208}}], 
          
          LineBox[{{-0.9484045818214244, -4.799067653114208}, \
{-0.9484045818214244, -4.782587093813652}}]}}}}}, {{{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.01]], 
        PointBox[CompressedData["
1:eJwVyXk813ccwHHH7z78bldULKuZErrF99P8WFZyLIxWS6F+pFrHj4RIQmUq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         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{Small, Small}]], 
        PointBox[CompressedData["
1:eJwVxXk81GkcAOAxxoxhxpzJFdsUqXRQKX3i9zqT3aUcRQopR01MuUq7Ulsp
LA3aSaXWUdKp0OXY91uRyrFoWCFyVCKMszGu3f3j+TwL/UWuAWQSibTjP/8v
XvcsXJM2D3pu8u4IinlI/+U12s4aPvg250euOMxDlPaq2gIJH/QKggPvu/EQ
4y9peZ0/H9a55XtbqfJQ8tTRCJEpHy54yTIc3nLR5XTbj25kPjwwud1QcoGL
dOKrm0Lf8oChmLAAZy66FGDwgPiDBwd5H6qXGnDRu7su51r9eWBg59N55zkH
xXru9QpYyoOHv/H6zLw4aHAm1Khqigt9q+9VWGtzUJBMnmhTxwW5PbnWqpWN
jns4FFtLuDD/FU+3+iQbaTqudrTw5YLNDrtVIUZsFD5D4XibcWF4vEPx5j0L
0TJOhohIXIhzlkQn67DQt1T1c0ZvOeAgsHzybL8GsmtTJF6ScIAnNN7umcFE
Cfb5rmcCOGBgodMyMMZAde4nLGmmHMj1eb3yuysDpd68+/T6JBs+evwsjEpQ
RzaZsao6FWzwLj77tTpbDXXt0uf/kMYGHuVaI3elGpLpHs+P3suGkSyDtg1b
6UjLMdMp3pQN3d6yrhtFqii65+9zrlMsePlneUnyRxrKirX1zhSzgCy6VajJ
pKGebbGE5nIWPH1XWtvnQUWaLV+iot5qQKigebmWqwry2+F6d6efBsSf7fjR
MY+CzPss/dvGmHB4zYL5AqkyspEOyYuTmRCQZcMqVZBR8FWz4fAVTPh8XLA2
m0pGNiYs/d0VDBixMqWQI5QQFt7Kq9nFgIEzCvM9x0hoY9DFvOBJdbhW9sB+
edAccVk77kSXWB1qFEplB0NniL5NLhGVxuqQcrpfxqVME5VVMdqPK9RglXDZ
hNVKBRHWQmf0+qiB39GimSSJnPgnaMuu2TE6mL4XKMjPJwgLelGYk5gOzlrC
FK/+McLJZRm71IQOx3zr2JlHRolqp4j0wVeqMKDzLZglGiYSO1/4hfiqgt6a
ZpZG3hDRKgg3tx2jgV9ju/baj/3EOPF7nK6YBpFKv5Td9ugl5mktevZ5Ow0M
X3xZZt74mTC8FOdj30UFfqp0n6FtN3Fdbrpg0xEqZLZIw/zsOwiPX1dzT3Oo
kDEp7N9o3UzE0rJDMx6oQLp1pntTcj3x2ogU2bBEBRpOke63cYAwueh0tTCX
Arq0EznrqalYzzY3foMHBSI9X3Z4uZTgV/eSHrZSKVDqK//UK3qNJbJ93dMS
ZajZHBR1my/FrR5fk34yUQZG4eHxkMRWzM/J3xxeSYZ7VWXdIxGd+HGAT5M0
kAxX5lQKmxQ92NxycTNVnQyV6ikhY0QvDq2PMQqSKEHBrFeQ8Pg37HuIdYNt
rAQhmR4ZcVtkmKxtXOKDSdBe2fSkwG4ER9RblZR7k2Bxi4a7aNEYDhQXeKdN
zuFjMZynSUPjOE3NXs1Baw63GTEPKNPlmPJVtlBhPYvZT0QNydoKXDaTvUX5
yAz+NWaJngVjGh+6Mtml8mgal4ZfKNIemMGNDL2o3dNTWPmRlBxfOoeXRj7s
6DOewvuNb7XqD5Cgp7b0bIuvAnf3pijPDirB1nntjf4nJ3HYPl5gqYYyjC60
dfxwT47pQ8+Tog0p4LBnmLn203fsKdJxizdTgTRe7f4Yw+84LUh8ymYtFXa2
snLKQiewZ/3RHfYraHDF58mE4Pw4Ts+3W+2zTxU+mOv7FhWP4QMvZ8srE+iw
wOuORH94FLcP7F6WnasGUXGxp+Z0R7FbVZIwq00dbnMTZoTbRrBzfEHtnBIT
4qvmOQeIh3EuI9gtVl8DyqR3G9a/kuGq85sWCVxYEDmXU3ejdwhH3DkYXbiZ
DXqSN2J3r0HMbOuUZ7Wz4V+EqqXC
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{0, Small}]], 
        PointBox[CompressedData["
1:eJwVxXk4lHkcAPCZMcyMmTEXEmLt5hYhpMP7Fqm2XMW6j3VbRQphF1GbVDZj
mFhPJEUlW+673/epKFcP1lV2IiR6InIfk9394/N81HzDTwSQCASC83/+P92k
7pw8RQ4mfI1NLPsYuMrzPIpbpyz4hOkak1SZOPld++tyoSzIiOi3uTUMnPG0
90WXrywUn3XMD9Jl4H+sx0SGG8rCeMVND/VYBv5ntuXISZIsaAiZjYon6Lhi
akd/WBsPfgV5JfNLdDwnQPUJlsUDz6SxjHEqHf/7kd2VIV8e+NQ2M3gvpfFE
Fz/XAG0exE932VrN0/AZcZhG+zoXjl8I0bYpouFBsyvXDnZxwdIOpXvtpOEJ
Ttb1B4RcmM5ajIx4SMW5WP6nrV5cqOpj3QuzoeKq2rxH50y4sO5XMrlaS8Gf
Rz14ZUfkgmpxpVuZHgVvP7sF9xrgwM2liguH6qTwfj8jelkuB4jLKqsxVCl8
4phG3IIvB/IcrEvy7STx3jCb28k7OKC7OtTU3EPGBfykpPA1Nhh2Vp9+sp2M
a61RzeltbBCPbLdvviKB/xJBflN3nQ3BWlMv+xEJtzr0SuOLDxtu8+JO3uKQ
8KV/hn5QM2NDLaXnMieFiOeoZ1zqILLBMrkhNnCEgI9qhkyb5bFgV160CseI
gNufavPL38+CySzf5UTRN+zXrIQazXYZKP2ib/NcV4ztcQ0I9/SSAUWu6Vph
0TrGCV+0Cllmwj6D+tx46TXsoR21gJvFhGyyqKL49xWsVlxETTFjglO9eet9
8jImGf/uTmwHA/xXZQP5botYof6I2tNABhy2DAxyLJzHgoPOiLElOkS43nXf
OzqHZSe92nS9Rofp3L7B1m2zWIezR8KmOh2EP6pgyW8/Yx3HjM1NmqUh38Tg
1LPYKcznQ7XtRrA0/NWQCfUWE9idzFAnoxUa8HPr39POjmI6JyxUtqTRoPVD
UuZYnAirisjfkqhJA32/oIo3Bf3YwB1nG7VGKngoONSKBjsx0xXlvdt+ooJA
4pB8Rj/CJqPcIyenKRB4ftbIfDoTS+q4HG94gwJKjoYbhpMViMinImU9CrBM
a6y6C1uQvoti38dmKeAX7Mla0OtBLeWl2/j+UtDDpyqqxw+iK7ytSmKCFBg5
Fqgybw2jN+8nXLKzJKHxvqmDd+oYUnOtMwrWkYQcTKDOsvuIgrNxDa82Miz2
80OFaZ+QsmVR6m4nMuzb81krSHUGtZSmlQ1JkWFX9LO7oadmkXDWf2xDKAFy
AW4yyW5f0ZDTVNpxPQmYs2uiFWgtINnCx4fPvSTB9e5gPH92EVUHePX3BpJg
hvpb7d7SZWS6f/ugFJ0EsnMB+yOtVlFYd7xGkJAIGn3uM3HO68j7DOseW4sI
XzMvFDcfESPSVq0GL0SAmETcLVV/E0V2WzS8cCeAQ4jtRsxFAgSml7sLVjdR
jJ7M2B5PIgikD0lbK2yiaxfHjKt9SECemlVbO/ANhfmu7KtylYAm8Z2jEufF
qAQRYq4fJ8OZ3NVRyaoN9HXeZEf8TknoYyhHe26sI8aTtAghSwq0o8qGP2mt
o506LgZAo8D468aUt95r6PZ6J59IpIK93Ls+36RV5PFtd72tDA3m1SyPiEpX
UEVnVWsEUxqsf55j7vqwjOTbdRonaHQQ8F6HxKsvI7ZO5fkHK3RwG2IVNoUt
oTXjqwYqIgbketUsfX9jETmlOA8rrTFBZKriXVm/gE4PDBjq0lmwzbVEqDI3
j2I0x80cqWyIvpx4cVNpHtmbV9rpCdnwkHtVHOrwFV1xzxAcVOBAarucbUD6
HJoq3zgqyOFAU++jHrOWWaStsHt/wndciNos7Lo3+QUZlg37FzzmgrKwNd3R
dQYRS6LaLIx48C9BoaGj
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -5.691200635903411}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-5.691200635903411, 
      6.370281377367599}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C20\"", "\"C21\"", "\"C22\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926118784707*^9},
 CellLabel->
  "Out[597]=",ExpressionUUID->"2d8fb16e-b523-4a94-a370-e65c330a5b27"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\DataMergedBinnedC20-22.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.9059261216775465`*^9},
 CellLabel->
  "Out[598]=",ExpressionUUID->"28aab3d0-e626-4d73-b502-bd8f1f6e18da"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -2.0093287828709796`}, \
{-5.352012198649872, -1.6814367993293893`}}], 
          
          LineBox[{{-5.352012198649872, -1.6814367993293893`}, \
{-5.352012198649872, -1.3535448157877992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -2.162449290062261}, \
{-5.197327949963066, -1.853973646897377}}], 
          
          LineBox[{{-5.197327949963066, -1.853973646897377}, \
{-5.197327949963066, -1.5454980037324935`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -2.0517235372113287`}, \
{-5.046182498246482, -1.7610744015672055`}}], 
          
          LineBox[{{-5.046182498246482, -1.7610744015672055`}, \
{-5.046182498246482, -1.4704252659230823`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0825971397420115`}, \
{-4.894444132978499, -1.7869663217644973`}}], 
          
          LineBox[{{-4.894444132978499, -1.7869663217644973`}, \
{-4.894444132978499, -1.491335503786983}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1808530865199893`}, \
{-4.745125399370905, -1.90031225283698}}], 
          
          LineBox[{{-4.745125399370905, -1.90031225283698}, \
{-4.745125399370905, -1.6197714191539707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.2183411497318897`}, \
{-4.596628633102665, -1.9599645382822033`}}], 
          
          LineBox[{{-4.596628633102665, -1.9599645382822033`}, \
{-4.596628633102665, -1.7015879268325167`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.2274008505891785`}, \
{-4.447741719114617, -1.9807057577397864`}}], 
          
          LineBox[{{-4.447741719114617, -1.9807057577397864`}, \
{-4.447741719114617, -1.7340106648903946`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.185318714234099}, \
{-4.298711959937622, -1.9531048696628939`}}], 
          
          LineBox[{{-4.298711959937622, -1.9531048696628939`}, \
{-4.298711959937622, -1.7208910250916887`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.219952502474402}, \
{-4.149632905511913, -2.001896117050877}}], 
          
          LineBox[{{-4.149632905511913, -2.001896117050877}, \
{-4.149632905511913, -1.7838397316273522`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.2274534134911748`}, \
{-4.001278268975371, -2.0285179870113916`}}], 
          
          LineBox[{{-4.001278268975371, -2.0285179870113916`}, \
{-4.001278268975371, -1.8295825605316085`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.4175562263623713`}, \
{-3.8508575458258987`, -2.225690849696841}}], 
          
          LineBox[{{-3.8508575458258987`, -2.225690849696841}, \
{-3.8508575458258987`, -2.033825473031311}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.2727215623528925`}, \
{-3.6998351226863213`, -2.0919678625081652`}}], 
          
          LineBox[{{-3.6998351226863213`, -2.0919678625081652`}, \
{-3.6998351226863213`, -1.9112141626634382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2629091764730767`}, \
{-3.550260154845919, -2.091929028752837}}], 
          
          LineBox[{{-3.550260154845919, -2.091929028752837}, \
{-3.550260154845919, -1.9209488810325972`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.322751107274743}, \
{-3.3997502222704012`, -2.165765529900271}}], 
          
          LineBox[{{-3.3997502222704012`, -2.165765529900271}, \
{-3.3997502222704012`, -2.008779952525799}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.3145014418751098`}, \
{-3.2492191603155653`, -2.1714505004601428`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1714505004601428`}, \
{-3.2492191603155653`, -2.0283995590451758`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2945559205990365`}, \
{-3.099363949694378, -2.1623787439387914`}}], 
          
          LineBox[{{-3.099363949694378, -2.1623787439387914`}, \
{-3.099363949694378, -2.0302015672785463`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3860474720718177`}, \
{-2.9723318619592627`, -2.1734384762855994`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1734384762855994`}, \
{-2.9723318619592627`, -1.960829480499381}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.3409563105713964`}, \
{-2.8161289018458944`, -2.03975469148549}}], 
          
          LineBox[{{-2.8161289018458944`, -2.03975469148549}, \
{-2.8161289018458944`, -1.738553072399584}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8279016767511895`}, \
{-2.637122953927779, -2.2657338500571558`}}], 
          
          LineBox[{{-2.637122953927779, -2.2657338500571558`}, \
{-2.637122953927779, -1.703566023363122}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.800252316094759}, \
{-2.4883394437723703`, -2.2763007569610387`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2763007569610387`}, \
{-2.4883394437723703`, -1.7523491978273182`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.859425707168809}, \
{-2.3426491274116255`, -2.3670959616362555`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3670959616362555`}, \
{-2.3426491274116255`, -1.8747662161037018`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.860830668535795}, \
{-2.1952323671440643`, -2.4037948759029937`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4037948759029937`}, \
{-2.1952323671440643`, -1.9467590832701922`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.9272322320171433`}, \
{-2.048114358050804, -2.479718655123771}}], 
          
          LineBox[{{-2.048114358050804, -2.479718655123771}, \
{-2.048114358050804, -2.0322050782303984`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.953375600295039}, \
{-1.9047213128625353`, -2.5367909172167677`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.5367909172167677`}, \
{-1.9047213128625353`, -2.1202062341384966`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.028642298198434}, \
{-1.7572185227137695`, -2.637889192357381}}], 
          
          LineBox[{{-1.7572185227137695`, -2.637889192357381}, \
{-1.7572185227137695`, -2.247136086516328}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1266725439928713`}, \
{-1.6053998639759, -2.754243549745302}}], 
          
          LineBox[{{-1.6053998639759, -2.754243549745302}, {-1.6053998639759, \
-2.3818145554977326`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.251344196972014}, \
{-1.4536487775630647`, -2.889392459094982}}], 
          
          LineBox[{{-1.4536487775630647`, -2.889392459094982}, \
{-1.4536487775630647`, -2.52744072121795}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.36788833133832}, \
{-1.3021571254789979`, -3.020276707551879}}], 
          
          LineBox[{{-1.3021571254789979`, -3.020276707551879}, \
{-1.3021571254789979`, -2.6726650837654375`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.5098073498850786`}, \
{-1.1509597708634107`, -3.1684928768164284`}}], 
          
          LineBox[{{-1.1509597708634107`, -3.1684928768164284`}, \
{-1.1509597708634107`, -2.8271784037477783`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6421170590085596`}, \
{-1.0007923805337786`, -3.3131005732446854`}}], 
          
          LineBox[{{-1.0007923805337786`, -3.3131005732446854`}, \
{-1.0007923805337786`, -2.984084087480811}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.722831385925379}, \
{-0.8504177096512346, -3.40891501624373}}], 
          
          LineBox[{{-0.8504177096512346, -3.40891501624373}, \
{-0.8504177096512346, -3.0949986465620807`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.1252793563099095`, -1.3528451653663944`}, \
{-5.1252793563099095`, -1.1433795214933027`}}], 
          
          LineBox[{{-5.1252793563099095`, -1.1433795214933027`}, \
{-5.1252793563099095`, -0.9339138776202109}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.972895007974446, -1.4467978539834505`}, \
{-4.972895007974446, -1.2260374126787217`}}], 
          
          LineBox[{{-4.972895007974446, -1.2260374126787217`}, \
{-4.972895007974446, -1.0052769713739929`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.8217116543319705`, -1.8090928756008526`}, \
{-4.8217116543319705`, -1.5870255304684209`}}], 
          
          LineBox[{{-4.8217116543319705`, -1.5870255304684209`}, \
{-4.8217116543319705`, -1.3649581853359891`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.673997009477748, -1.7201331254683612`}, \
{-4.673997009477748, -1.5072343590697368`}}], 
          
          LineBox[{{-4.673997009477748, -1.5072343590697368`}, \
{-4.673997009477748, -1.2943355926711124`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.5248234384963775`, -1.911503421821114}, \
{-4.5248234384963775`, -1.694867955095279}}], 
          
          LineBox[{{-4.5248234384963775`, -1.694867955095279}, \
{-4.5248234384963775`, -1.478232488369444}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.37075571259779, -1.9410342050813103`}, \
{-4.37075571259779, -1.7333780006790314`}}], 
          
          LineBox[{{-4.37075571259779, -1.7333780006790314`}, \
{-4.37075571259779, -1.5257217962767524`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.218821591988268, -2.025125721518314}, \
{-4.218821591988268, -1.8333400247972242`}}], 
          
          LineBox[{{-4.218821591988268, -1.8333400247972242`}, \
{-4.218821591988268, -1.6415543280761344`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.0694770795907385`, -2.0338505814348116`}, \
{-4.0694770795907385`, -1.8415704137385887`}}], 
          
          LineBox[{{-4.0694770795907385`, -1.8415704137385887`}, \
{-4.0694770795907385`, -1.6492902460423657`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.918560524201742, -2.232652532918944}, \
{-3.918560524201742, -2.037689312909757}}], 
          
          LineBox[{{-3.918560524201742, -2.037689312909757}, \
{-3.918560524201742, -1.8427260929005702`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7690418430970776`, -2.2469329242210914`}, \
{-3.7690418430970776`, -2.050470813269418}}], 
          
          LineBox[{{-3.7690418430970776`, -2.050470813269418}, \
{-3.7690418430970776`, -1.8540087023177443`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.620833185567976, -2.1924751125763615`}, \
{-3.620833185567976, -2.0078450826643963`}}], 
          
          LineBox[{{-3.620833185567976, -2.0078450826643963`}, \
{-3.620833185567976, -1.823215052752431}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4709577855367924`, -2.327943111848826}, \
{-3.4709577855367924`, -2.1672420250239024`}}], 
          
          LineBox[{{-3.4709577855367924`, -2.1672420250239024`}, \
{-3.4709577855367924`, -2.0065409381989787`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.320602706761705, -2.2819923140511977`}, \
{-3.320602706761705, -2.130575773770181}}], 
          
          LineBox[{{-3.320602706761705, -2.130575773770181}, \
{-3.320602706761705, -1.9791592334891646`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.170051886202171, -2.325960853381056}, \
{-3.170051886202171, -2.178668004677789}}], 
          
          LineBox[{{-3.170051886202171, -2.178668004677789}, \
{-3.170051886202171, -2.031375155974522}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.030477377590662, -2.364963478329096}, \
{-3.030477377590662, -2.215833089497624}}], 
          
          LineBox[{{-3.030477377590662, -2.215833089497624}, \
{-3.030477377590662, -2.066702700666152}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8877051576271007`, -2.4470810453712706`}, \
{-2.8877051576271007`, -2.0308235141317508`}}], 
          
          LineBox[{{-2.8877051576271007`, -2.0308235141317508`}, \
{-2.8877051576271007`, -1.614565982892231}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.7272330204080557`, -2.765905625269932}, \
{-2.7272330204080557`, -2.2167173422497792`}}], 
          
          LineBox[{{-2.7272330204080557`, -2.2167173422497792`}, \
{-2.7272330204080557`, -1.6675290592296266`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5654914303840752`, -2.7566653381080948`}, \
{-2.5654914303840752`, -2.242092245770433}}], 
          
          LineBox[{{-2.5654914303840752`, -2.242092245770433}, \
{-2.5654914303840752`, -1.727519153432771}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4167532824388296`, -2.7966935161724824`}, \
{-2.4167532824388296`, -2.2729773346218276`}}], 
          
          LineBox[{{-2.4167532824388296`, -2.2729773346218276`}, \
{-2.4167532824388296`, -1.7492611530711728`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.273683103959538, -2.7892211361624484`}, \
{-2.273683103959538, -2.320537873341196}}], 
          
          LineBox[{{-2.273683103959538, -2.320537873341196}, \
{-2.273683103959538, -1.8518546105199438`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1225114762089117`, -2.8236710408799715`}, \
{-2.1225114762089117`, -2.3937844289603167`}}], 
          
          LineBox[{{-2.1225114762089117`, -2.3937844289603167`}, \
{-2.1225114762089117`, -1.9638978170406618`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9688530566493743`, -2.8229541872537505`}, \
{-1.9688530566493743`, -2.420665764815222}}], 
          
          LineBox[{{-1.9688530566493743`, -2.420665764815222}, \
{-1.9688530566493743`, -2.0183773423766933`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8165848867407983`, -2.8752021559189758`}, \
{-1.8165848867407983`, -2.490287621993528}}], 
          
          LineBox[{{-1.8165848867407983`, -2.490287621993528}, \
{-1.8165848867407983`, -2.1053730880680805`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6679573417952833`, -2.943694442125146}, \
{-1.6679573417952833`, -2.573234246260398}}], 
          
          LineBox[{{-1.6679573417952833`, -2.573234246260398}, \
{-1.6679573417952833`, -2.20277405039565}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5211693704213907`, -3.0180240138702534`}, \
{-1.5211693704213907`, -2.666104615926631}}], 
          
          LineBox[{{-1.5211693704213907`, -2.666104615926631}, \
{-1.5211693704213907`, -2.3141852179830082`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.371988295897768, -3.092946448022707}, \
{-1.371988295897768, -2.7627217465836353`}}], 
          
          LineBox[{{-1.371988295897768, -2.7627217465836353`}, \
{-1.371988295897768, -2.4324970451445638`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2210917594318125`, -3.1916284426259494`}, \
{-1.2210917594318125`, -2.8740183095344505`}}], 
          
          LineBox[{{-1.2210917594318125`, -2.8740183095344505`}, \
{-1.2210917594318125`, -2.5564081764429516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0718189592856806`, -3.3051122988253487`}, \
{-1.0718189592856806`, -2.996429944455006}}], 
          
          LineBox[{{-1.0718189592856806`, -2.996429944455006}, \
{-1.0718189592856806`, -2.6877475900846637`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.1252793563099095`, -0.96477943753508}, \
{-5.1252793563099095`, -0.7391686344009561}}], 
          
          LineBox[{{-5.1252793563099095`, -0.7391686344009561}, \
{-5.1252793563099095`, -0.5135578312668323}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.972895007974446, -0.9535993632839864}, \
{-4.972895007974446, -0.7133739101905257}}], 
          
          LineBox[{{-4.972895007974446, -0.7133739101905257}, \
{-4.972895007974446, -0.4731484570970649}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.8217116543319705`, -1.4920352848705054`}, \
{-4.8217116543319705`, -1.2734305782197923`}}], 
          
          LineBox[{{-4.8217116543319705`, -1.2734305782197923`}, \
{-4.8217116543319705`, -1.0548258715690793`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.673830349076903, -1.3157870376537555`}, \
{-4.673830349076903, -1.1270814075746538`}}], 
          
          LineBox[{{-4.673830349076903, -1.1270814075746538`}, \
{-4.673830349076903, -0.9383757774955521}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.521216293266271, -1.6531108264067091`}, \
{-4.521216293266271, -1.3983615441650237`}}], 
          
          LineBox[{{-4.521216293266271, -1.3983615441650237`}, \
{-4.521216293266271, -1.1436122619233382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.3682219300566025`, -1.7992520141962367`}, \
{-4.3682219300566025`, -1.465059688428702}}], 
          
          LineBox[{{-4.3682219300566025`, -1.465059688428702}, \
{-4.3682219300566025`, -1.1308673626611672`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.223924574573319, -1.9645624717370351`}, \
{-4.223924574573319, -1.6245590795392313`}}], 
          
          LineBox[{{-4.223924574573319, -1.6245590795392313`}, \
{-4.223924574573319, -1.2845556873414274`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.077721657523017, -2.038209780364534}, \
{-4.077721657523017, -1.7147861404360367`}}], 
          
          LineBox[{{-4.077721657523017, -1.7147861404360367`}, \
{-4.077721657523017, -1.3913625005075394`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.92630264206681, -2.1494508829121255`}, \
{-3.92630264206681, -1.8478089031935414`}}], 
          
          LineBox[{{-3.92630264206681, -1.8478089031935414`}, \
{-3.92630264206681, -1.546166923474957}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.774327986151194, -2.245759723513893}, \
{-3.774327986151194, -1.9383472878026295`}}], 
          
          LineBox[{{-3.774327986151194, -1.9383472878026295`}, \
{-3.774327986151194, -1.6309348520913662`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6208826994945396`, -2.334711992235891}, \
{-3.6208826994945396`, -2.0395686420545247`}}], 
          
          LineBox[{{-3.6208826994945396`, -2.0395686420545247`}, \
{-3.6208826994945396`, -1.7444252918731584`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4686602504493296`, -2.399748237667733}, \
{-3.4686602504493296`, -2.1091620931464528`}}], 
          
          LineBox[{{-3.4686602504493296`, -2.1091620931464528`}, \
{-3.4686602504493296`, -1.8185759486251727`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.320632854288721, -2.4784768658854617`}, \
{-3.320632854288721, -2.2038471789535055`}}], 
          
          LineBox[{{-3.320632854288721, -2.2038471789535055`}, \
{-3.320632854288721, -1.9292174920215492`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.169887377457001, -2.4564658324092714`}, \
{-3.169887377457001, -2.2050530434335336`}}], 
          
          LineBox[{{-3.169887377457001, -2.2050530434335336`}, \
{-3.169887377457001, -1.953640254457796}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.01721515252269, -2.345074896394708}, \
{-3.01721515252269, -2.120912908334111}}], 
          
          LineBox[{{-3.01721515252269, -2.120912908334111}, \
{-3.01721515252269, -1.8967509202735144`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.869122979428457, -2.3248215745985488`}, \
{-2.869122979428457, -2.125116138908417}}], 
          
          LineBox[{{-2.869122979428457, -2.125116138908417}, \
{-2.869122979428457, -1.9254107032182852`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.7229707239555854`, -2.4101854065991413`}, \
{-2.7229707239555854`, -2.222581347955065}}], 
          
          LineBox[{{-2.7229707239555854`, -2.222581347955065}, \
{-2.7229707239555854`, -2.034977289310989}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5674984695241374`, -2.4585576605778705`}, \
{-2.5674984695241374`, -2.1167607486550155`}}], 
          
          LineBox[{{-2.5674984695241374`, -2.1167607486550155`}, \
{-2.5674984695241374`, -1.7749638367321607`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4167532824388296`, -2.730676061111512}, \
{-2.4167532824388296`, -2.215365091833709}}], 
          
          LineBox[{{-2.4167532824388296`, -2.215365091833709}, \
{-2.4167532824388296`, -1.7000541225559056`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.273683103959538, -2.7151373798005185`}, \
{-2.273683103959538, -2.260552152824246}}], 
          
          LineBox[{{-2.273683103959538, -2.260552152824246}, \
{-2.273683103959538, -1.8059669258479734`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1225114762089117`, -2.7223200485296535`}, \
{-2.1225114762089117`, -2.3072025595882764`}}], 
          
          LineBox[{{-2.1225114762089117`, -2.3072025595882764`}, \
{-2.1225114762089117`, -1.8920850706468992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9688530566493743`, -2.710030614808251}, \
{-1.9688530566493743`, -2.3236366231172294`}}], 
          
          LineBox[{{-1.9688530566493743`, -2.3236366231172294`}, \
{-1.9688530566493743`, -1.9372426314262075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8165848867407983`, -2.736987228862975}, \
{-1.8165848867407983`, -2.372330782351529}}], 
          
          LineBox[{{-1.8165848867407983`, -2.372330782351529}, \
{-1.8165848867407983`, -2.0076743358400835`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6679573417952833`, -2.7655887838744464`}, \
{-1.6679573417952833`, -2.420561808974977}}], 
          
          LineBox[{{-1.6679573417952833`, -2.420561808974977}, \
{-1.6679573417952833`, -2.0755348340755075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5211693704213907`, -2.7982903951784612`}, \
{-1.5211693704213907`, -2.4733619472453525`}}], 
          
          LineBox[{{-1.5211693704213907`, -2.4733619472453525`}, \
{-1.5211693704213907`, -2.148433499312244}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.371988295897768, -2.848351894935505}, \
{-1.371988295897768, -2.543378251816936}}], 
          
          LineBox[{{-1.371988295897768, -2.543378251816936}, \
{-1.371988295897768, -2.238404608698367}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2210917594318125`, -2.9077092438776244`}, \
{-1.2210917594318125`, -2.6181369569061665`}}], 
          
          LineBox[{{-1.2210917594318125`, -2.6181369569061665`}, \
{-1.2210917594318125`, -2.3285646699347087`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0718189592856806`, -2.942973344943205}, \
{-1.0718189592856806`, -2.6680361941378496`}}], 
          
          LineBox[{{-1.0718189592856806`, -2.6680361941378496`}, \
{-1.0718189592856806`, -2.3930990433324943`}}]}}}}, {{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -1.3535448157877992`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -1.3535448157877992`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -2.0093287828709796`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -2.0093287828709796`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -1.5454980037324935`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -1.5454980037324935`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -2.162449290062261}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -2.162449290062261}]}, \
{{-5.197327949963066, -2.162449290062261}, 
             Offset[{-3, 0}, {-5.197327949963066, -2.162449290062261}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.4704252659230823`}, 
             Offset[{3, 
              0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -1.4704252659230823`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -2.0517235372113287`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -2.0517235372113287`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.491335503786983}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -1.491335503786983}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.0825971397420115`}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -2.0825971397420115`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.6197714191539707`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -1.6197714191539707`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.1808530865199893`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.1808530865199893`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.7015879268325167`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -1.7015879268325167`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.2183411497318897`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -2.2183411497318897`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.7340106648903946`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -1.7340106648903946`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.2274008505891785`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
             Offset[{-3, 
              0}, {-4.447741719114617, -2.2274008505891785`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.7208910250916887`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -1.7208910250916887`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -2.185318714234099}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.185318714234099}]}, \
{{-4.298711959937622, -2.185318714234099}, 
             Offset[{-3, 0}, {-4.298711959937622, -2.185318714234099}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.7838397316273522`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -1.7838397316273522`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -2.219952502474402}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.219952502474402}]}, \
{{-4.149632905511913, -2.219952502474402}, 
             Offset[{-3, 0}, {-4.149632905511913, -2.219952502474402}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.8295825605316085`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -1.8295825605316085`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.2274534134911748`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -2.2274534134911748`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -2.033825473031311}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.033825473031311}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.4175562263623713`}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.4175562263623713`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.9112141626634382`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -1.9112141626634382`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.2727215623528925`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.2727215623528925`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.9209488810325972`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -1.9209488810325972`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.2629091764730767`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -2.2629091764730767`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -2.008779952525799}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.008779952525799}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.322751107274743}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.322751107274743}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -2.0283995590451758`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.0283995590451758`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.3145014418751098`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.3145014418751098`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -2.0302015672785463`}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.0302015672785463`}]}, \
{{-3.099363949694378, -2.0302015672785463`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.0302015672785463`}]}, \
{{-3.099363949694378, -2.2945559205990365`}, 
             Offset[{3, 
              0}, {-3.099363949694378, -2.2945559205990365`}]}, \
{{-3.099363949694378, -2.2945559205990365`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.2945559205990365`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.960829480499381}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.960829480499381}]}, \
{{-2.9723318619592627`, -1.960829480499381}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.960829480499381}]}, \
{{-2.9723318619592627`, -2.3860474720718177`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.3860474720718177`}]}, \
{{-2.9723318619592627`, -2.3860474720718177`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.3860474720718177`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.738553072399584}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.738553072399584}]}, \
{{-2.8161289018458944`, -1.738553072399584}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.738553072399584}]}, \
{{-2.8161289018458944`, -2.3409563105713964`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.3409563105713964`}]}, \
{{-2.8161289018458944`, -2.3409563105713964`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.3409563105713964`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.703566023363122}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.703566023363122}]}, \
{{-2.637122953927779, -1.703566023363122}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.703566023363122}]}, \
{{-2.637122953927779, -2.8279016767511895`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.8279016767511895`}]}, \
{{-2.637122953927779, -2.8279016767511895`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.8279016767511895`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.7523491978273182`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.7523491978273182`}]}, \
{{-2.4883394437723703`, -1.7523491978273182`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.7523491978273182`}]}, \
{{-2.4883394437723703`, -2.800252316094759}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.800252316094759}]}, \
{{-2.4883394437723703`, -2.800252316094759}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.800252316094759}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.8747662161037018`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.8747662161037018`}]}, \
{{-2.3426491274116255`, -1.8747662161037018`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.8747662161037018`}]}, \
{{-2.3426491274116255`, -2.859425707168809}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.859425707168809}]}, \
{{-2.3426491274116255`, -2.859425707168809}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.859425707168809}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.9467590832701922`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.9467590832701922`}]}, \
{{-2.1952323671440643`, -1.9467590832701922`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.9467590832701922`}]}, \
{{-2.1952323671440643`, -2.860830668535795}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.860830668535795}]}, \
{{-2.1952323671440643`, -2.860830668535795}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.860830668535795}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -2.0322050782303984`}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.0322050782303984`}]}, \
{{-2.048114358050804, -2.0322050782303984`}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.0322050782303984`}]}, \
{{-2.048114358050804, -2.9272322320171433`}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.9272322320171433`}]}, \
{{-2.048114358050804, -2.9272322320171433`}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.9272322320171433`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.1202062341384966`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.1202062341384966`}]}, \
{{-1.9047213128625353`, -2.1202062341384966`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.1202062341384966`}]}, \
{{-1.9047213128625353`, -2.953375600295039}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.953375600295039}]}, \
{{-1.9047213128625353`, -2.953375600295039}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.953375600295039}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.247136086516328}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.247136086516328}]}, \
{{-1.7572185227137695`, -2.247136086516328}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.247136086516328}]}, \
{{-1.7572185227137695`, -3.028642298198434}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -3.028642298198434}]}, \
{{-1.7572185227137695`, -3.028642298198434}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -3.028642298198434}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.3818145554977326`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.3818145554977326`}]}, \
{{-1.6053998639759, -2.3818145554977326`}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.3818145554977326`}]}, \
{{-1.6053998639759, -3.1266725439928713`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -3.1266725439928713`}]}, \
{{-1.6053998639759, -3.1266725439928713`}, 
             Offset[{-3, 0}, {-1.6053998639759, -3.1266725439928713`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.52744072121795}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.52744072121795}]}, \
{{-1.4536487775630647`, -2.52744072121795}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.52744072121795}]}, \
{{-1.4536487775630647`, -3.251344196972014}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.251344196972014}]}, \
{{-1.4536487775630647`, -3.251344196972014}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.251344196972014}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.6726650837654375`}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.6726650837654375`}]}, \
{{-1.3021571254789979`, -2.6726650837654375`}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.6726650837654375`}]}, \
{{-1.3021571254789979`, -3.36788833133832}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.36788833133832}]}, \
{{-1.3021571254789979`, -3.36788833133832}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.36788833133832}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.8271784037477783`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.8271784037477783`}]}, \
{{-1.1509597708634107`, -2.8271784037477783`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.8271784037477783`}]}, \
{{-1.1509597708634107`, -3.5098073498850786`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.5098073498850786`}]}, \
{{-1.1509597708634107`, -3.5098073498850786`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.5098073498850786`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0007923805337786`, -2.984084087480811}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -2.984084087480811}]}, \
{{-1.0007923805337786`, -2.984084087480811}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -2.984084087480811}]}, \
{{-1.0007923805337786`, -3.6421170590085596`}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.6421170590085596`}]}, \
{{-1.0007923805337786`, -3.6421170590085596`}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.6421170590085596`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-0.8504177096512346, -3.0949986465620807`}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.0949986465620807`}]}, \
{{-0.8504177096512346, -3.0949986465620807`}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.0949986465620807`}]}, \
{{-0.8504177096512346, -3.722831385925379}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.722831385925379}]}, \
{{-0.8504177096512346, -3.722831385925379}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.722831385925379}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.1252793563099095`, -0.9339138776202109}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -0.9339138776202109}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -1.3528451653663944`}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -1.3528451653663944`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.972895007974446, -1.0052769713739929`}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.0052769713739929`}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -1.4467978539834505`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -1.4467978539834505`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.8217116543319705`, -1.3649581853359891`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.3649581853359891`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.8090928756008526`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.8090928756008526`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.673997009477748, -1.2943355926711124`}, 
             
             Offset[{3, 
              0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.2943355926711124`}, 
             
             Offset[{-3, 
              0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
             
             Offset[{3, 
              0}, {-4.673997009477748, -1.7201331254683612`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
             
             Offset[{-3, 
              0}, {-4.673997009477748, -1.7201331254683612`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.5248234384963775`, -1.478232488369444}, 
             
             Offset[{3, 
              0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.478232488369444}, 
             
             Offset[{-3, 
              0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
             
             Offset[{3, 
              0}, {-4.5248234384963775`, -1.911503421821114}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
             
             Offset[{-3, 
              0}, {-4.5248234384963775`, -1.911503421821114}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.37075571259779, -1.5257217962767524`}, 
             
             Offset[{3, 
              0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.5257217962767524`}, 
             
             Offset[{-3, 
              0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
             
             Offset[{3, 
              0}, {-4.37075571259779, -1.9410342050813103`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
             
             Offset[{-3, 
              0}, {-4.37075571259779, -1.9410342050813103`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.218821591988268, -1.6415543280761344`}, 
             
             Offset[{3, 
              0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -1.6415543280761344`}, 
             
             Offset[{-3, 
              0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -2.025125721518314}, 
             
             Offset[{3, 
              0}, {-4.218821591988268, -2.025125721518314}]}, \
{{-4.218821591988268, -2.025125721518314}, 
             Offset[{-3, 0}, {-4.218821591988268, -2.025125721518314}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.0694770795907385`, -1.6492902460423657`}, 
             
             Offset[{3, 
              0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -1.6492902460423657`}, 
             
             Offset[{-3, 
              0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
             
             Offset[{3, 
              0}, {-4.0694770795907385`, -2.0338505814348116`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
             
             Offset[{-3, 
              0}, {-4.0694770795907385`, -2.0338505814348116`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.918560524201742, -1.8427260929005702`}, 
             
             Offset[{3, 
              0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -1.8427260929005702`}, 
             
             Offset[{-3, 
              0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -2.232652532918944}, 
             
             Offset[{3, 
              0}, {-3.918560524201742, -2.232652532918944}]}, \
{{-3.918560524201742, -2.232652532918944}, 
             Offset[{-3, 0}, {-3.918560524201742, -2.232652532918944}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.7690418430970776`, -1.8540087023177443`}, 
             
             Offset[{3, 
              0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -1.8540087023177443`}, 
             
             Offset[{-3, 
              0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
             
             Offset[{3, 
              0}, {-3.7690418430970776`, -2.2469329242210914`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
             
             Offset[{-3, 
              0}, {-3.7690418430970776`, -2.2469329242210914`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.620833185567976, -1.823215052752431}, 
             
             Offset[{3, 
              0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -1.823215052752431}, 
             
             Offset[{-3, 
              0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
             
             Offset[{3, 
              0}, {-3.620833185567976, -2.1924751125763615`}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
             
             Offset[{-3, 
              0}, {-3.620833185567976, -2.1924751125763615`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4709577855367924`, -2.0065409381989787`}, 
             
             Offset[{3, 
              0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.0065409381989787`}, 
             
             Offset[{-3, 
              0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
             
             Offset[{3, 
              0}, {-3.4709577855367924`, -2.327943111848826}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
             
             Offset[{-3, 
              0}, {-3.4709577855367924`, -2.327943111848826}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.320602706761705, -1.9791592334891646`}, 
             
             Offset[{3, 
              0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -1.9791592334891646`}, 
             
             Offset[{-3, 
              0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
             
             Offset[{3, 
              0}, {-3.320602706761705, -2.2819923140511977`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
             
             Offset[{-3, 
              0}, {-3.320602706761705, -2.2819923140511977`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.170051886202171, -2.031375155974522}, 
             
             Offset[{3, 
              0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.031375155974522}, 
             
             Offset[{-3, 
              0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.325960853381056}, 
             
             Offset[{3, 
              0}, {-3.170051886202171, -2.325960853381056}]}, \
{{-3.170051886202171, -2.325960853381056}, 
             Offset[{-3, 0}, {-3.170051886202171, -2.325960853381056}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.030477377590662, -2.066702700666152}, 
             
             Offset[{3, 
              0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.066702700666152}, 
             
             Offset[{-3, 
              0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.364963478329096}, 
             
             Offset[{3, 
              0}, {-3.030477377590662, -2.364963478329096}]}, \
{{-3.030477377590662, -2.364963478329096}, 
             Offset[{-3, 0}, {-3.030477377590662, -2.364963478329096}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8877051576271007`, -1.614565982892231}, 
             
             Offset[{3, 
              0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -1.614565982892231}, 
             
             Offset[{-3, 
              0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
             
             Offset[{3, 
              0}, {-2.8877051576271007`, -2.4470810453712706`}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
             
             Offset[{-3, 
              0}, {-2.8877051576271007`, -2.4470810453712706`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.7272330204080557`, -1.6675290592296266`}, 
             
             Offset[{3, 
              0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -1.6675290592296266`}, 
             
             Offset[{-3, 
              0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
             
             Offset[{3, 
              0}, {-2.7272330204080557`, -2.765905625269932}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
             
             Offset[{-3, 
              0}, {-2.7272330204080557`, -2.765905625269932}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5654914303840752`, -1.727519153432771}, 
             
             Offset[{3, 
              0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -1.727519153432771}, 
             
             Offset[{-3, 
              0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
             
             Offset[{3, 
              0}, {-2.5654914303840752`, -2.7566653381080948`}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
             
             Offset[{-3, 
              0}, {-2.5654914303840752`, -2.7566653381080948`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4167532824388296`, -1.7492611530711728`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -1.7492611530711728`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -2.7966935161724824`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -2.7966935161724824`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.273683103959538, -1.8518546105199438`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -1.8518546105199438`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -2.7892211361624484`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -2.7892211361624484`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1225114762089117`, -1.9638978170406618`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -1.9638978170406618`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -2.8236710408799715`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -2.8236710408799715`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9688530566493743`, -2.0183773423766933`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.0183773423766933`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.8229541872537505`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.8229541872537505`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8165848867407983`, -2.1053730880680805`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.1053730880680805`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.8752021559189758`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.8752021559189758`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6679573417952833`, -2.20277405039565}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.20277405039565}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.943694442125146}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.943694442125146}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5211693704213907`, -2.3141852179830082`}, 
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -2.3141852179830082`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -3.0180240138702534`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -3.0180240138702534`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.371988295897768, -2.4324970451445638`}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -2.4324970451445638`}, 
             
             Offset[{-3, 
              0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -3.092946448022707}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -3.092946448022707}]}, \
{{-1.371988295897768, -3.092946448022707}, 
             Offset[{-3, 0}, {-1.371988295897768, -3.092946448022707}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2210917594318125`, -2.5564081764429516`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -2.5564081764429516`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -3.1916284426259494`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -3.1916284426259494`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0718189592856806`, -2.6877475900846637`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -2.6877475900846637`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -3.3051122988253487`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -3.3051122988253487`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.1252793563099095`, -0.5135578312668323}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.5135578312668323}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.96477943753508}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.96477943753508}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.972895007974446, -0.4731484570970649}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.4731484570970649}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -0.9535993632839864}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -0.9535993632839864}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.8217116543319705`, -1.0548258715690793`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.0548258715690793`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.4920352848705054`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.4920352848705054`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.673830349076903, -0.9383757774955521}, 
             
             Offset[{3, 
              0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -0.9383757774955521}, 
             
             Offset[{-3, 
              0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
             
             Offset[{3, 
              0}, {-4.673830349076903, -1.3157870376537555`}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
             
             Offset[{-3, 
              0}, {-4.673830349076903, -1.3157870376537555`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.521216293266271, -1.1436122619233382`}, 
             
             Offset[{3, 
              0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.1436122619233382`}, 
             
             Offset[{-3, 
              0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
             
             Offset[{3, 
              0}, {-4.521216293266271, -1.6531108264067091`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
             
             Offset[{-3, 
              0}, {-4.521216293266271, -1.6531108264067091`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.3682219300566025`, -1.1308673626611672`}, 
             
             Offset[{3, 
              0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.1308673626611672`}, 
             
             Offset[{-3, 
              0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
             
             Offset[{3, 
              0}, {-4.3682219300566025`, -1.7992520141962367`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
             
             Offset[{-3, 
              0}, {-4.3682219300566025`, -1.7992520141962367`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.223924574573319, -1.2845556873414274`}, 
             
             Offset[{3, 
              0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.2845556873414274`}, 
             
             Offset[{-3, 
              0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
             
             Offset[{3, 
              0}, {-4.223924574573319, -1.9645624717370351`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
             
             Offset[{-3, 
              0}, {-4.223924574573319, -1.9645624717370351`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.077721657523017, -1.3913625005075394`}, 
             
             Offset[{3, 
              0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -1.3913625005075394`}, 
             
             Offset[{-3, 
              0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -2.038209780364534}, 
             
             Offset[{3, 
              0}, {-4.077721657523017, -2.038209780364534}]}, \
{{-4.077721657523017, -2.038209780364534}, 
             Offset[{-3, 0}, {-4.077721657523017, -2.038209780364534}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.92630264206681, -1.546166923474957}, 
             
             Offset[{3, 
              0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -1.546166923474957}, 
             
             Offset[{-3, 
              0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
             
             Offset[{3, 
              0}, {-3.92630264206681, -2.1494508829121255`}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
             
             Offset[{-3, 
              0}, {-3.92630264206681, -2.1494508829121255`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.774327986151194, -1.6309348520913662`}, 
             
             Offset[{3, 
              0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -1.6309348520913662`}, 
             
             Offset[{-3, 
              0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -2.245759723513893}, 
             
             Offset[{3, 
              0}, {-3.774327986151194, -2.245759723513893}]}, \
{{-3.774327986151194, -2.245759723513893}, 
             Offset[{-3, 0}, {-3.774327986151194, -2.245759723513893}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6208826994945396`, -1.7444252918731584`}, 
             
             Offset[{3, 
              0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -1.7444252918731584`}, 
             
             Offset[{-3, 
              0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
             
             Offset[{3, 
              0}, {-3.6208826994945396`, -2.334711992235891}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
             
             Offset[{-3, 
              0}, {-3.6208826994945396`, -2.334711992235891}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4686602504493296`, -1.8185759486251727`}, 
             
             Offset[{3, 
              0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -1.8185759486251727`}, 
             
             Offset[{-3, 
              0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
             
             Offset[{3, 
              0}, {-3.4686602504493296`, -2.399748237667733}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
             
             Offset[{-3, 
              0}, {-3.4686602504493296`, -2.399748237667733}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.320632854288721, -1.9292174920215492`}, 
             
             Offset[{3, 
              0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -1.9292174920215492`}, 
             
             Offset[{-3, 
              0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
             
             Offset[{3, 
              0}, {-3.320632854288721, -2.4784768658854617`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
             
             Offset[{-3, 
              0}, {-3.320632854288721, -2.4784768658854617`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.169887377457001, -1.953640254457796}, 
             
             Offset[{3, 
              0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -1.953640254457796}, 
             
             Offset[{-3, 
              0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
             
             Offset[{3, 
              0}, {-3.169887377457001, -2.4564658324092714`}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
             
             Offset[{-3, 
              0}, {-3.169887377457001, -2.4564658324092714`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.01721515252269, -1.8967509202735144`}, 
             
             Offset[{3, 
              0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -1.8967509202735144`}, 
             
             Offset[{-3, 
              0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -2.345074896394708}, 
             
             Offset[{3, 
              0}, {-3.01721515252269, -2.345074896394708}]}, \
{{-3.01721515252269, -2.345074896394708}, 
             Offset[{-3, 0}, {-3.01721515252269, -2.345074896394708}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.869122979428457, -1.9254107032182852`}, 
             
             Offset[{3, 
              0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -1.9254107032182852`}, 
             
             Offset[{-3, 
              0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
             
             Offset[{3, 
              0}, {-2.869122979428457, -2.3248215745985488`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
             
             Offset[{-3, 
              0}, {-2.869122979428457, -2.3248215745985488`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.7229707239555854`, -2.034977289310989}, 
             
             Offset[{3, 
              0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.034977289310989}, 
             
             Offset[{-3, 
              0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
             
             Offset[{3, 
              0}, {-2.7229707239555854`, -2.4101854065991413`}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
             
             Offset[{-3, 
              0}, {-2.7229707239555854`, -2.4101854065991413`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5674984695241374`, -1.7749638367321607`}, 
             
             Offset[{3, 
              0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -1.7749638367321607`}, 
             
             Offset[{-3, 
              0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
             
             Offset[{3, 
              0}, {-2.5674984695241374`, -2.4585576605778705`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
             
             Offset[{-3, 
              0}, {-2.5674984695241374`, -2.4585576605778705`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4167532824388296`, -1.7000541225559056`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -1.7000541225559056`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -2.730676061111512}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -2.730676061111512}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.273683103959538, -1.8059669258479734`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -1.8059669258479734`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -2.7151373798005185`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -2.7151373798005185`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1225114762089117`, -1.8920850706468992`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -1.8920850706468992`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -2.7223200485296535`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -2.7223200485296535`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9688530566493743`, -1.9372426314262075`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -1.9372426314262075`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.710030614808251}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.710030614808251}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8165848867407983`, -2.0076743358400835`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.0076743358400835`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.736987228862975}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.736987228862975}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6679573417952833`, -2.0755348340755075`}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.0755348340755075`}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.7655887838744464`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.7655887838744464`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5211693704213907`, -2.148433499312244}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.148433499312244}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.7982903951784612`}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.7982903951784612`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.371988295897768, -2.238404608698367}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.238404608698367}, 
             
             Offset[{-3, 
              0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.848351894935505}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.848351894935505}]}, \
{{-1.371988295897768, -2.848351894935505}, 
             Offset[{-3, 0}, {-1.371988295897768, -2.848351894935505}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2210917594318125`, -2.3285646699347087`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.3285646699347087`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.9077092438776244`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.9077092438776244`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0718189592856806`, -2.3930990433324943`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.3930990433324943`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.942973344943205}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.942973344943205}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}}}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAHvrD4nVoFcD9kfZFKuf6v162jlYQ
yhTAEx9RReCp/b8Cd/52Si8UwNrcCFpcLfy/iPesKemTE8DIgnD/aZf8vy/e
FicC+xLAc/ch0q1n/r/tIcyd8mISwG3ek8YDXP+/wJsiznzKEcBK3EeF+LD/
v7JsS4zhMRHAfsRN5Oo//78GUU5eOZkQwILIhRziAwDAYsctF08BEMBSfmyj
ZzoAwDYEp2aOzg7AlKITATfOAcA7PSQoQ5kNwHULjqVZvADASNfKy+5mDMAw
X2BJRbwAwMbCmT6wMgvAY87N4HxTAcBIvHidZv4JwIjfonAhXwHAv7WSU3/L
CMDnQhY6jUwBwGLKX+1VxwfAJh48tjNjAcDz/PWWbocGwI1XXuhqUQDAsDRV
69MYBcA3fJsROSACwBXLooIe6APAyA/YK901AsAP42HTvr0CwGfF7QHQ7wLA
DgnA/NWPAcCrXdLO+DoDwLJe0seJYgDANU34u3bWA8AE0isOvXn+vwvjUQlZ
SwTAerJvK5Ed/L+oLB2mZRoFwCx4jMS3r/m/CwCb17AIBsBTD3g4JUL3v8n5
KMt5HQfAe/jCtaLV9L9vcp7VhikIwIjr7cpUavK/vUgcyxJZCcA1qAffPgPw
v+eOk986gQrAVoVcM58267+L4Ww8dUULwCKg+PY=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMCGrTtTSEvyv4PExpY+
5BPAggryZ9md8784ZKjHbkkTwHR29OF0ZPm/JDylRSyyEsDrynnGoR34v5kQ
wlBrGRLADcNi3C0e+7+WprFip3sRwF1bCJLqu/u/Ov50xBLgEMADO49ZXFX9
v76n4v8kRxDAZp3EiRJ3/b+qvpZCNlkPwFTZ8g0wTQDAL9zqaP8mDsBKKOM9
XWcAwKNJomN39wzA8dIrFREQAMC2avWDhcQLwK/0n/yCVgHAomfkJpiQCsBN
8a9PawsBwDrkzilEXAnAIHanfeltAcBsKGDsaj4IwKVL5rIGugHAy/1jKQUa
B8A5JglmID8AwIzKuYtf0QXAv4JLTda7AcDJV/1eIIYEwPiXMQ/O7wHAeJq0
voJVA8D//6W9Di8CwLjKZ8SAMALA4wkZKXaQAsCcnf1L5/oAwAF4YHN4JgPA
6AQPEGyA/7/3bDMDhl0DwH5ab1C7EP2/OsSw6hvsA8AxJKIJ9K/6v8AVJdb7
lQTAQzCasbVW+L/H9CioLlQFwM4C1v+p8/W/nTLs2w0aBsC2y0KDl4nzvwNy
vE/9/QbACNYVoysm8b/Jg0FDsPgHwJpU4k8=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMARZd/6RKfnv4PExpY+
5BPAetDChfXT5r84ZKjHbkkTwNTi8r34X/S/qllBlQCyEsCRZ5eDhgjyv0ji
Vrm5FRLA8MPCWrBf9r9sDW0rD3kRwN3Th23icPe/okDSe0zlEMBep1CpMf75
v1MCJUSWTxDA0uiMl8Nv+7+0AA9cEWkPwA6VhxGgkP2/5CwH39IxDsAGcRZy
eAP/v5bZR1mR9wzADZI8XQlRAMCa6wTy0L8LwCI3IGCQ3wDAp4s59aeQCsC3
5TeheqEBwL5y0entWwnAOPCb2fKjAcAUpaiyQSMIwI2s1y+h9wDAR8emv/bz
BsDvgebjPAABwGTW+t+kyAXAM1XRutjHAcD8FjmjPIoEwCpwZ0Ig7wDAeJq0
voJVA8CsAVFVEbkBwLjKZ8SAMALAn0L6XZwVAsCcnf1L5/oAwOBulZ0mdQLA
6AQPEGyA/79snEDMzpYCwH5ab1C7EP2/iPOrj4j6AsAxJKIJ9K/6v/jze4JP
XQPAQzCasbVW+L+jtxT9cckDwM4C1v+p8/W/iEpnstZYBMC2y0KDl4nzvzjj
8snx8QTACNYVoysm8b9U7jJcI1gFwKGU7og=
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6., 0.}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C20\"", "\"C21\"", "\"C22\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926122507908*^9},
 CellLabel->
  "Out[599]=",ExpressionUUID->"29ed393f-3515-45b4-b349-04093821cfc3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\SlopesC20-22.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.9059261239865217`*^9},
 CellLabel->
  "Out[600]=",ExpressionUUID->"ce288b73-ba8a-4ed6-8271-ef0514dac6a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"datamergedbinned", "\[IndentingNewLine]", "slopes"}], "Input",
 CellChangeTimes->{{3.9022175431613054`*^9, 3.9022175645953445`*^9}},
 CellLabel->
  "In[1115]:=",ExpressionUUID->"4a97ea6b-d69e-429c-bd7d-48eda4881d0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.005201837102883252`", ",", 
     InterpretationBox[
      TemplateBox[{"2155.", "23."},
       "Around"],
      Around[2154.5342816089687`, 22.537686649429933`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.005499576460586653`", ",", 
     InterpretationBox[
      TemplateBox[{"2054.", "25."},
       "Around"],
      Around[2053.9233474331827`, 25.26857148814141]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.005797312621757746`", ",", 
     InterpretationBox[
      TemplateBox[{"1963.", "26."},
       "Around"],
      Around[1963.1122862017212`, 26.37427990499248]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006095046256411147`", ",", 
     InterpretationBox[
      TemplateBox[{"1866.", "22."},
       "Around"],
      Around[1865.6480510729866`, 22.21304241889695]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006392778183245567`", ",", 
     InterpretationBox[
      TemplateBox[{"1792.", "20."},
       "Around"],
      Around[1791.674612295816, 19.72744766497742]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006764257393695457`", ",", 
     InterpretationBox[
      TemplateBox[{"1710.", "18."},
       "Around"],
      Around[1709.9634599334834`, 17.778372675415273`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007137099112045789`", ",", 
     InterpretationBox[
      TemplateBox[{"1637.", "14."},
       "Around"],
      Around[1637.4155705445692`, 13.680596386673885`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007434825416390654`", ",", 
     InterpretationBox[
      TemplateBox[{"1578.", "11."},
       "Around"],
      Around[1578.149754560084, 11.442067724879013`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007806389674491179`", ",", 
     InterpretationBox[
      TemplateBox[{"1518.", "14."},
       "Around"],
      Around[1518.4055142519446`, 14.039532778773344`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008253006324791026`", ",", 
     InterpretationBox[
      TemplateBox[{"1456.", "12."},
       "Around"],
      Around[1456.4071118905097`, 12.485619656709783`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00869961771751182`", ",", 
     InterpretationBox[
      TemplateBox[{"1392.", "12."},
       "Around"],
      Around[1391.6119282768288`, 11.798521479218124`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009146225554390526`", ",", 
     InterpretationBox[
      TemplateBox[{"1336.", "10."},
       "Around"],
      Around[1336.3307567321613`, 9.746422488288497]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009592828599447845`", ",", 
     InterpretationBox[
      TemplateBox[{"1287.", "9."},
       "Around"],
      Around[1287.2178927872071`, 9.240299218139592]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010039428299368077`", ",", 
     InterpretationBox[
      TemplateBox[{"1242.", "8."},
       "Around"],
      Around[1241.6715482779123`, 8.48768143292912]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010559845549853002`", ",", 
     InterpretationBox[
      TemplateBox[{"1191.", "9."},
       "Around"],
      Around[1190.8054767677168`, 8.859763353654362]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011155336853319231`", ",", 
     InterpretationBox[
      TemplateBox[{"1140.", "8."},
       "Around"],
      Around[1140.4190233846543`, 7.566516628994655]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011750820603656205`", ",", 
     InterpretationBox[
      TemplateBox[{"1092.", "8."},
       "Around"],
      Around[1091.8982266124524`, 7.74991786490775]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01234629804675764`", ",", 
     InterpretationBox[
      TemplateBox[{"1046.", "7."},
       "Around"],
      Around[1046.1644623507036`, 7.381674476674525]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012941770487071803`", ",", 
     InterpretationBox[
      TemplateBox[{"1004.", "7."},
       "Around"],
      Around[1003.8013523174574`, 6.828532095641284]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01361106148142078`", ",", 
     InterpretationBox[
      TemplateBox[{"960.", "7."},
       "Around"],
      Around[960.0479098429114, 6.778826153625681]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014281567927393166`", ",", 
     InterpretationBox[
      TemplateBox[{"919.", "6."},
       "Around"],
      Around[919.0737831795414, 6.129856371383698]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015024662906253355`", ",", 
     InterpretationBox[
      TemplateBox[{"878.", "6."},
       "Around"],
      Around[877.6122248474493, 6.105000964703162]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01584411837076666`", ",", 
     InterpretationBox[
      TemplateBox[{"832.", "6."},
       "Around"],
      Around[832.4953809008723, 6.093466325974668]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.016588458547160068`", ",", 
     InterpretationBox[
      TemplateBox[{"793.", "5."},
       "Around"],
      Around[792.786391988797, 5.075875500226863]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01740664119430597`", ",", 
     InterpretationBox[
      TemplateBox[{"754.", "5."},
       "Around"],
      Around[754.4368802771114, 4.815022682884135]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.018299862710163702`", ",", 
     InterpretationBox[
      TemplateBox[{"714.", "5."},
       "Around"],
      Around[714.3529215672822, 4.987822381902303]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.019266886837587722`", ",", 
     InterpretationBox[
      TemplateBox[{"674.", "5."},
       "Around"],
      Around[674.3325220709842, 5.114678016763027]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.020303734207070448`", ",", 
     InterpretationBox[
      TemplateBox[{"648.", "11."},
       "Around"],
      Around[648.3786883083336, 10.916059858652691`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0213192161319613`", ",", 
     InterpretationBox[
      TemplateBox[{"609.", "11."},
       "Around"],
      Around[608.9359325091817, 10.615294139418214`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.022383043720548668`", ",", 
     InterpretationBox[
      TemplateBox[{"575.", "10."},
       "Around"],
      Around[575.1686325263693, 9.732651867186629]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.023510226818942992`", ",", 
     InterpretationBox[
      TemplateBox[{"531.", "8."},
       "Around"],
      Around[530.7522434427915, 7.73936416377065]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02474693139885536`", ",", 
     InterpretationBox[
      TemplateBox[{"493.", "8."},
       "Around"],
      Around[493.4058225793257, 7.501921243199549]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.026042759548619034`", ",", 
     InterpretationBox[
      TemplateBox[{"456.", "7."},
       "Around"],
      Around[455.7890948642452, 6.80112506993077]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.027391400108538484`", ",", 
     InterpretationBox[
      TemplateBox[{"417.", "5."},
       "Around"],
      Around[417.46621147628764`, 5.46908333372723]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02879968504337793`", ",", 
     InterpretationBox[
      TemplateBox[{"383.", "5."},
       "Around"],
      Around[383.23596024158655`, 5.112239356018193]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.030206037746627695`", ",", 
     InterpretationBox[
      TemplateBox[{"350.", "4."},
       "Around"],
      Around[350.39224106298974`, 4.49346788259267]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03178180620776831`", ",", 
     InterpretationBox[
      TemplateBox[{"318.", "4."},
       "Around"],
      Around[318.483584024733, 3.908492056978478]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.033412502419480565`", ",", 
     InterpretationBox[
      TemplateBox[{"286.2", "3.3"},
       "Around"],
      Around[286.20005024630234`, 3.34526741604642]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0351001705910135`", ",", 
     InterpretationBox[
      TemplateBox[{"258.6", "3.1"},
       "Around"],
      Around[258.61499406587427`, 3.0671288108947077`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03695802295088222`", ",", 
     InterpretationBox[
      TemplateBox[{"230.5", "2.7"},
       "Around"],
      Around[230.46200229258582`, 2.6676107805428475`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03887215155093279`", ",", 
     InterpretationBox[
      TemplateBox[{"205.1", "2.3"},
       "Around"],
      Around[205.1107479909898, 2.343411871563886]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04083854454470471`", ",", 
     InterpretationBox[
      TemplateBox[{"182.5", "2.0"},
       "Around"],
      Around[182.51719647674514`, 1.9736596488130485`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.042923095638888326`", ",", 
     InterpretationBox[
      TemplateBox[{"160.7", "1.6"},
       "Around"],
      Around[160.6651952300454, 1.624300870678604]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0451146594259945`", ",", 
     InterpretationBox[
      TemplateBox[{"141.5", "1.5"},
       "Around"],
      Around[141.5062933043256, 1.5210583754986662`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04742394880629512`", ",", 
     InterpretationBox[
      TemplateBox[{"123.8", "1.3"},
       "Around"],
      Around[123.76287902980424`, 1.2569162902073192`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.049847562493721013`", ",", 
     InterpretationBox[
      TemplateBox[{"107.7", "1.1"},
       "Around"],
      Around[107.72483557025865`, 1.094457094438784]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05140190867133607`", ",", 
     InterpretationBox[
      TemplateBox[{"100.6", "1.7"},
       "Around"],
      Around[100.6120262231068, 1.7486465919513805`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.054226208478212364`", ",", "90.02174972745411`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.056965511292219176`", ",", "77.04412677060084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.061059105731659194`", ",", 
     InterpretationBox[
      TemplateBox[{"61.", "5."},
       "Around"],
      Around[61.40878951629754, 4.544732420360533]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06518342345952988`", ",", "49.430247880108425`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06792272627353668`", ",", "43.03804035516409`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07066202908754349`", ",", "37.600006168991705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07475843765055092`", ",", 
     InterpretationBox[
      TemplateBox[{"30.9", "2.0"},
       "Around"],
      Around[30.949607818570477`, 1.9598232820732782`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0788799375295639`", ",", "25.698866866941383`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08161924034357071`", ",", "22.80026469108519`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08571725262936242`", ",", 
     InterpretationBox[
      TemplateBox[{"19.2", "1.1"},
       "Around"],
      Around[19.187733090154648`, 1.0844697154133252`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09119651559349819`", ",", 
     InterpretationBox[
      TemplateBox[{"15.4", "0.8"},
       "Around"],
      Around[15.381787412840431`, 0.8289285480364212]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09531575441360474`", ",", "13.126739792561423`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0994152741891374`", ",", 
     InterpretationBox[
      TemplateBox[{"11.3", "0.6"},
       "Around"],
      Around[11.29529139023409, 0.5553102249335157]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10489437257692662`", ",", 
     InterpretationBox[
      TemplateBox[{"9.3", "0.4"},
       "Around"],
      Around[9.298198703937464, 0.44990391977381194`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.11037342204429214`", ",", 
     InterpretationBox[
      TemplateBox[{"7.70", "0.35"},
       "Around"],
      Around[7.702498362090075, 0.34989481231712555`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.11585242953206629`", ",", 
     InterpretationBox[
      TemplateBox[{"6.45", "0.28"},
       "Around"],
      Around[6.446853615128146, 0.28213513334885154`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.12268839788779111`", ",", 
     InterpretationBox[
      TemplateBox[{"5.20", "0.25"},
       "Around"],
      Around[5.195191805393805, 0.25223937257135914`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.12954980323056883`", ",", 
     InterpretationBox[
      TemplateBox[{"4.23", "0.17"},
       "Around"],
      Around[4.231337786530305, 0.16899077225910333`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13502870261542155`", ",", 
     InterpretationBox[
      TemplateBox[{"3.62", "0.14"},
       "Around"],
      Around[3.6191699663739714`, 0.13822773633377983`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14186627362406254`", ",", 
     InterpretationBox[
      TemplateBox[{"3.01", "0.13"},
       "Around"],
      Around[3.005937475546762, 0.12629058659533104`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.15008515005547005`", ",", 
     InterpretationBox[
      TemplateBox[{"2.43", "0.10"},
       "Around"],
      Around[2.434293985488234, 0.09625984540220538]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.15830392125237788`", ",", 
     InterpretationBox[
      TemplateBox[{"1.98", "0.08"},
       "Around"],
      Around[1.9833153041463731`, 0.07533320847201644]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.16652261200283527`", ",", 
     InterpretationBox[
      TemplateBox[{"1.64", "0.06"},
       "Around"],
      Around[1.63665161665206, 0.0586619672722567]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17474122442236315`", ",", 
     InterpretationBox[
      TemplateBox[{"1.36", "0.05"},
       "Around"],
      Around[1.3641998316153463`, 0.04695181847784789]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18295977833723456`", ",", 
     InterpretationBox[
      TemplateBox[{"1.14", "0.04"},
       "Around"],
      Around[1.1447049160836966`, 0.037892843564035134`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.19253664929395495`", ",", 
     InterpretationBox[
      TemplateBox[{"0.942", "0.033"},
       "Around"],
      Around[0.9424010096481048, 0.0330369094169658]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9022175471048417`*^9, 3.902217565141075*^9}, 
   3.903580773342307*^9},
 CellLabel->
  "Out[1115]=",ExpressionUUID->"383de0f5-94a7-4abb-8284-448085624608"],

Cell[BoxData["slopes"], "Output",
 CellChangeTimes->{{3.9022175471048417`*^9, 3.902217565141075*^9}, 
   3.9035807733981733`*^9},
 CellLabel->
  "Out[1116]=",ExpressionUUID->"f5c632f4-6bd7-434d-b6e2-d0e56bb3a4ec"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->
  "In[1117]:=",ExpressionUUID->"fc1ebc98-ef4f-4738-a070-36d8553dc98a"],

Cell[TextData[StyleBox["Plot slope fit", "Subsection"]], "Text",
 CellChangeTimes->{{3.90221326727293*^9, 3.902213268872779*^9}, {
  3.9022132993769493`*^9, 3.9022133123279767`*^9}, {3.90221837905232*^9, 
  3.9022183810135107`*^9}},ExpressionUUID->"1a55261a-6883-4734-9f89-\
3ea1d5ad02d6"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
     "\"\<PlateletsSlopeFitC14.pdf\>\""}], "}"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9023825711530323`*^9, 3.9023825774062014`*^9}},
 CellLabel->
  "In[1118]:=",ExpressionUUID->"b1335785-6eb1-4fa2-b4a3-e677d4e7313c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Save", " ", "slopefits"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"slopeFitC14", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.947", ",", " ", "0.771", ",", " ", "5.513", ",", " ", "0.619"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC15", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.559", ",", " ", "0.852", ",", " ", "5.363", ",", " ", "0.550"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC16", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.193", ",", " ", "0.975", ",", " ", "4.931", ",", " ", "0.701"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC20", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.893", ",", " ", "0.769", ",", " ", "5.654", ",", " ", "0.782"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC21", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.542", ",", " ", "0.908", ",", " ", "5.00", ",", " ", "0.603"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC22", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "0.686", ",", " ", "1.209", ",", " ", "4.715", ",", " ", "0.536"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"slopesC14", ",", "\[IndentingNewLine]", "slopeFitC14"}], " ", 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Binned data C14\>\"", ",", " ", "\"\<Fit C14\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", " ", "+", " ", "C15"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC14", ",", "\[IndentingNewLine]", "slopesC15", ",", 
        "\[IndentingNewLine]", "slopeFitC14", " ", ",", "\[IndentingNewLine]",
         "slopeFitC15"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C14\>\"", ",", " ", "\"\<Binned data C15\>\"", ",", 
         " ", "\"\<Fit C14\>\"", ",", " ", "\"\<Fit C15\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", " ", "True", ",", " ", "True"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", " ", "Automatic", ",", " ", "None", ",", " ", 
         "None"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14-C15.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", "-", "C16"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC14", ",", "\[IndentingNewLine]", "slopesC15", ",", 
        "\[IndentingNewLine]", "slopesC16", ",", "\[IndentingNewLine]", 
        "slopeFitC14", " ", ",", "\[IndentingNewLine]", "slopeFitC15", ",", 
        "\[IndentingNewLine]", "slopeFitC16"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C14\>\"", ",", " ", "\"\<Binned data C15\>\"", ",", 
         " ", "\"\<Binned data C16\>\"", ",", " ", "\"\<Fit C14\>\"", ",", 
         " ", "\"\<Fit C15\>\"", ",", " ", "\"\<Fit C16\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{
        "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
         "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
         "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14-C16.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", "-", 
     RowBox[{"C16", " ", "without", " ", "errors"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFitNE", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC14NE", ",", "\[IndentingNewLine]", "slopesC15NE", ",", 
        "\[IndentingNewLine]", "slopesC16NE", ",", "\[IndentingNewLine]", 
        "slopeFitC14", " ", ",", "\[IndentingNewLine]", "slopeFitC15", ",", 
        "\[IndentingNewLine]", "slopeFitC16"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C14\>\"", ",", " ", "\"\<Binned data C15\>\"", ",", 
         " ", "\"\<Binned data C16\>\"", ",", " ", "\"\<Fit C14\>\"", ",", 
         " ", "\"\<Fit C15\>\"", ",", " ", "\"\<Fit C16\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{
        "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
         "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
         "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14-C16_no_error.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFitNE", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"slopesC20", ",", "\[IndentingNewLine]", "slopeFitC20"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Binned data C20\>\"", ",", " ", "\"\<Fit C20\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", " ", "+", " ", "C21"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopeFitC20", ",", "\[IndentingNewLine]", 
        "slopeFitC21"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C20\>\"", ",", " ", "\"\<Binned data C21\>\"", ",", 
         " ", "\"\<Fit C20\>\"", ",", " ", "\"\<Fit C21\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", " ", "True", ",", " ", "True"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", " ", "Automatic", ",", " ", "None", ",", " ", 
         "None"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C21.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", "-", "C22"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopesC22", ",", "\[IndentingNewLine]", 
        "slopeFitC20", ",", "\[IndentingNewLine]", "slopeFitC21", ",", 
        "\[IndentingNewLine]", "slopeFitC22"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C20\>\"", ",", " ", "\"\<Binned data C21\>\"", ",", 
         " ", "\"\<Binned data C22\>\"", ",", " ", "\"\<Fit C20\>\"", ",", 
         " ", "\"\<Fit C21\>\"", ",", " ", "\"\<Fit C22\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{
        "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
         "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
         "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", "-", 
     RowBox[{"C22", " ", "without", " ", "errors"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFitNE", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC20NE", ",", "\[IndentingNewLine]", "slopesC21NE", ",", 
        "\[IndentingNewLine]", "slopesC22NE", ",", "\[IndentingNewLine]", 
        "slopeFitC20", ",", "\[IndentingNewLine]", "slopeFitC21", ",", 
        "\[IndentingNewLine]", "slopeFitC22"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data C20\>\"", ",", " ", "\"\<Binned data C21\>\"", ",", 
         " ", "\"\<Binned data C22\>\"", ",", " ", "\"\<Fit C20\>\"", ",", 
         " ", "\"\<Fit C21\>\"", ",", " ", "\"\<Fit C22\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{
        "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
         "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
         "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C22_no_errors.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFitNE", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, {
   3.9022143351373234`*^9, 3.9022143457075415`*^9}, {3.902217269696082*^9, 
   3.902217270200951*^9}, {3.9022173155310507`*^9, 3.9022173399244585`*^9}, {
   3.9022173951254196`*^9, 3.902217398451253*^9}, {3.9022183993095517`*^9, 
   3.9022184967246695`*^9}, {3.902218567194338*^9, 3.902218589926301*^9}, {
   3.9022186355594287`*^9, 3.9022186384144664`*^9}, 3.9022186788903103`*^9, {
   3.90221872157267*^9, 3.902218790754416*^9}, 3.9022189075570207`*^9, {
   3.9022189860362177`*^9, 3.902219064270348*^9}, {3.902219301983201*^9, 
   3.902219506364025*^9}, {3.9022195367201366`*^9, 3.9022195644502935`*^9}, 
   3.9022195981147165`*^9, {3.9022196644479475`*^9, 3.902219826419914*^9}, {
   3.902219870182803*^9, 3.902219949602034*^9}, {3.9022199887895393`*^9, 
   3.902220146909876*^9}, {3.9022205683106046`*^9, 3.902220577493764*^9}, {
   3.9022215866550646`*^9, 3.902221783962392*^9}, {3.9023786995737205`*^9, 
   3.902378984723471*^9}, {3.9024597161117487`*^9, 3.902459739274332*^9}, {
   3.9024597791701097`*^9, 3.9024598198842497`*^9}, {3.904795250463937*^9, 
   3.9047953383134565`*^9}, {3.9047956629414744`*^9, 
   3.9047957535926833`*^9}, {3.904798306979192*^9, 3.9047983512027273`*^9}, {
   3.904798382546859*^9, 3.904798410143236*^9}, {3.904798496961456*^9, 
   3.9047985009846196`*^9}, {3.905926172370016*^9, 3.9059261935734367`*^9}},
 CellLabel->
  "In[601]:=",ExpressionUUID->"53db37f2-ab19-4a4d-8175-4749ca30cef4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8VG0bPmaYscxwMLaxRIhSSagIR1G0W5NUShKlJMkSoSSF9Gkk1FBK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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-4.1575798222214395`, 0}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Binned data C14\"", "\"Fit C14\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9},
 CellLabel->
  "Out[607]=",ExpressionUUID->"9157cc4d-772e-4a46-afd7-52532fff24d3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\PlateletsSlopeFitC14.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261973767166`*^9},
 CellLabel->
  "Out[608]=",ExpressionUUID->"fa54fc5d-394b-4d32-ae51-3dd6ef895c39"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}}}, {{{}, {}, {}, {}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8VG0bPmaYscxwMLaxRIhSSagIR1G0W5NUShKlJMkSoSSF9Gkk1FBK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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8Fe8bvS6u9TJyuVxZo5QWhKIytyxJiUJKsheFKElkq1SKVrvkK6lE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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.72]], CompressedData["
1:eJwB5QEa/iFib1JlAwAAAB0AAAABAAAAAgAAAB76w+J1aBXAkup33+lt8r9e
to5WEMoUwJak/EOOHvG/Anf+dkovFMDO1IGf3NH6v4j3rCnpkxPALF+jkCnN
+78v3hYnAvsSwKpBfc3gM/2/7SHMnfJiEsC5LPGry1v8v8CbIs58yhHA1/gu
mzBc/L+ybEuM4TERwL6fk78pmP2/BlFOXjmZEMDbqHF7rkIAwGLHLRdPARDA
E1nVSE65/r82BKdmjs4OwAEuUcwUoAHAOz0kKEOZDcB9zVnLwRIBwEjXysvu
ZgzAQQ2ZXOxgAMDGwpk+sDILwOLIHILxowDASLx4nWb+CcBda8SGv+IAwL+1
klN/ywjAcTMnYL7NAMBiyl/tVccHwO0Im2JrWgHA8/z1lm6HBsAlEmN7zBwA
wLA0VevTGAXAx5UmuEmmAcAVy6KCHugDwByV2JDAzgHAD+Nh0769AsBdBDhQ
X1YCwA4JwPzVjwHAwgsBKsiiAsCyXtLHiWIAwOuWuT1mEAPABNIrDr15/r8c
FugICHMDwHqybyuRHfy/+6O7RFgXBMAseIzEt6/5v+CK1Gbc6ATAUw94OCVC
978DO+FgPZQFwHv4wrWi1fS/WahE7IWQBsCI6+3KVGryv8CR3V9kWgfAW2rv
UQ==
         "]]}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-4.1575798222214395`, 0}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Binned data C14\"", "\"Binned data C15\"", "\"Fit C14\"", 
       "\"Fit C15\""}, "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.2358333333333333] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.905926197580626*^9},
 CellLabel->
  "Out[609]=",ExpressionUUID->"01e96dca-3c5e-4c50-aa13-f37720a522e9"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\PlateletsSlopeFitC14-C15.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.905926198303752*^9},
 CellLabel->
  "Out[610]=",ExpressionUUID->"3e79f877-879c-41ab-80c7-c34f1d153ff2"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.962020517152551, -1.7975229365155172`}, \
{-4.962020517152551, -1.4904522790582342`}}], 
          
          LineBox[{{-4.962020517152551, -1.4904522790582342`}, \
{-4.962020517152551, -1.1833816216009512`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.812318020609066, -1.7499804854261338`}, \
{-4.812318020609066, -1.484844590276649}}], 
          
          LineBox[{{-4.812318020609066, -1.484844590276649}, \
{-4.812318020609066, -1.219708695127164}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.662288009830052, -1.731832308155819}, \
{-4.662288009830052, -1.484844094732198}}], 
          
          LineBox[{{-4.662288009830052, -1.484844094732198}, \
{-4.662288009830052, -1.237855881308577}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.510921616983912, -2.1820005297355953`}, \
{-4.510921616983912, -1.9277101971080235`}}], 
          
          LineBox[{{-4.510921616983912, -1.9277101971080235`}, \
{-4.510921616983912, -1.6734198644804519`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.358825697731176, -1.7496301838784403`}, \
{-4.358825697731176, -1.5407870885745718`}}], 
          
          LineBox[{{-4.358825697731176, -1.5407870885745718`}, \
{-4.358825697731176, -1.3319439932707033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.206267641506683, -2.0186112646490657`}, \
{-4.206267641506683, -1.8301249552977674`}}], 
          
          LineBox[{{-4.206267641506683, -1.8301249552977674`}, \
{-4.206267641506683, -1.6416386459464691`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.056255653469975, -2.045423498599775}, \
{-4.056255653469975, -1.8298421264932705`}}], 
          
          LineBox[{{-4.056255653469975, -1.8298421264932705`}, \
{-4.056255653469975, -1.6142607543867664`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.9071666992729934`, -2.2539753896725387`}, \
{-3.9071666992729934`, -2.048083845765819}}], 
          
          LineBox[{{-3.9071666992729934`, -2.048083845765819}, \
{-3.9071666992729934`, -1.8421923018590989`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7563029605395606`, -2.356016322351946}, \
{-3.7563029605395606`, -2.1793864693343323`}}], 
          
          LineBox[{{-3.7563029605395606`, -2.1793864693343323`}, \
{-3.7563029605395606`, -2.0027566163167188`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6055069407082008`, -2.0712591417540867`}, \
{-3.6055069407082008`, -1.9041921854873916`}}], 
          
          LineBox[{{-3.6055069407082008`, -1.9041921854873916`}, \
{-3.6055069407082008`, -1.7371252292206965`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4564260807134493`, -2.3154337014558}, \
{-3.4564260807134493`, -2.1486849495091764`}}], 
          
          LineBox[{{-3.4564260807134493`, -2.1486849495091764`}, \
{-3.4564260807134493`, -1.9819361975625527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3071524238710044`, -2.236134018237064}, \
{-3.3071524238710044`, -2.0916457307990073`}}], 
          
          LineBox[{{-3.3071524238710044`, -2.0916457307990073`}, \
{-3.3071524238710044`, -1.9471574433609504`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.156690529396256, -2.207572101104361}, \
{-3.156690529396256, -2.0758943792454656`}}], 
          
          LineBox[{{-3.156690529396256, -2.0758943792454656`}, \
{-3.156690529396256, -1.9442166573865698`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.0195378319942416`, -2.242122341649085}, \
{-3.0195378319942416`, -2.0720360768688115`}}], 
          
          LineBox[{{-3.0195378319942416`, -2.0720360768688115`}, \
{-3.0195378319942416`, -1.9019498120885379`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8585261080745212`, -2.317698131453854}, \
{-2.8585261080745212`, -2.0032105152590582`}}], 
          
          LineBox[{{-2.8585261080745212`, -2.0032105152590582`}, \
{-2.8585261080745212`, -1.6887228990642622`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.691382454472379, -2.78784802624227}, \
{-2.691382454472379, -2.1892779813885275`}}], 
          
          LineBox[{{-2.691382454472379, -2.1892779813885275`}, \
{-2.691382454472379, -1.5907079365347847`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5545155316419494`, -2.7417402803813147`}, \
{-2.5545155316419494`, -2.1924652191783975`}}], 
          
          LineBox[{{-2.5545155316419494`, -2.1924652191783975`}, \
{-2.5545155316419494`, -1.6431901579754804`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.408966023604327, -2.7235790038725742`}, \
{-2.408966023604327, -2.242770317295063}}], 
          
          LineBox[{{-2.408966023604327, -2.242770317295063}, \
{-2.408966023604327, -1.7619616307175516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.2588388882868426`, -2.729795390355834}, \
{-2.2588388882868426`, -2.268822869979683}}], 
          
          LineBox[{{-2.2588388882868426`, -2.268822869979683}, \
{-2.2588388882868426`, -1.807850349603532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1096964413451786`, -2.7535327288177047`}, \
{-2.1096964413451786`, -2.3379921382936306`}}], 
          
          LineBox[{{-2.1096964413451786`, -2.3379921382936306`}, \
{-2.1096964413451786`, -1.9224515477695563`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9578947894818906`, -2.7345648695754594`}, \
{-1.9578947894818906`, -2.3436357189221946`}}], 
          
          LineBox[{{-1.9578947894818906`, -2.3436357189221946`}, \
{-1.9578947894818906`, -1.9527065682689297`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8071283500440232`, -2.7889862251377617`}, \
{-1.8071283500440232`, -2.4214478851744476`}}], 
          
          LineBox[{{-1.8071283500440232`, -2.4214478851744476`}, \
{-1.8071283500440232`, -2.0539095452111336`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.65618364739931, -2.81505323267394}, \
{-1.65618364739931, -2.4706079244040438`}}], 
          
          LineBox[{{-1.65618364739931, -2.4706079244040438`}, \
{-1.65618364739931, -2.1261626161341476`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5040228008910033`, -2.875105173039695}, \
{-1.5040228008910033`, -2.5481456990090083`}}], 
          
          LineBox[{{-1.5040228008910033`, -2.5481456990090083`}, \
{-1.5040228008910033`, -2.2211862249783216`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3539296288670801`, -2.956534168031409}, \
{-1.3539296288670801`, -2.6412677590483873`}}], 
          
          LineBox[{{-1.3539296288670801`, -2.6412677590483873`}, \
{-1.3539296288670801`, -2.326001350065366}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2055237319284868`, -3.0030836819866935`}, \
{-1.2055237319284868`, -2.702590293800939}}], 
          
          LineBox[{{-1.2055237319284868`, -2.702590293800939}, \
{-1.2055237319284868`, -2.4020969056151844`}}]}}}}}, {{{}, {}, {}, {}, {}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8VG0bPmaYscxwMLaxRIhSSagIR1G0W5NUShKlJMkSoSSF9Gkk1FBK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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8Fe8bvS6u9TJyuVxZo5QWhKIytyxJiUJKsheFKElkq1SKVrvkK6lE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         "]]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1Vnk4lGsfHoOxm7ENxhJFHJSydXTwOlkSH2lQIqkhpVQkLVL2SlTWRHLs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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.72]], CompressedData["
1:eJwB5QEa/iFib1JlAwAAAB0AAAABAAAAAgAAAB76w+J1aBXAkup33+lt8r9e
to5WEMoUwJak/EOOHvG/Anf+dkovFMDO1IGf3NH6v4j3rCnpkxPALF+jkCnN
+78v3hYnAvsSwKpBfc3gM/2/7SHMnfJiEsC5LPGry1v8v8CbIs58yhHA1/gu
mzBc/L+ybEuM4TERwL6fk78pmP2/BlFOXjmZEMDbqHF7rkIAwGLHLRdPARDA
E1nVSE65/r82BKdmjs4OwAEuUcwUoAHAOz0kKEOZDcB9zVnLwRIBwEjXysvu
ZgzAQQ2ZXOxgAMDGwpk+sDILwOLIHILxowDASLx4nWb+CcBda8SGv+IAwL+1
klN/ywjAcTMnYL7NAMBiyl/tVccHwO0Im2JrWgHA8/z1lm6HBsAlEmN7zBwA
wLA0VevTGAXAx5UmuEmmAcAVy6KCHugDwByV2JDAzgHAD+Nh0769AsBdBDhQ
X1YCwA4JwPzVjwHAwgsBKsiiAsCyXtLHiWIAwOuWuT1mEAPABNIrDr15/r8c
FugICHMDwHqybyuRHfy/+6O7RFgXBMAseIzEt6/5v+CK1Gbc6ATAUw94OCVC
978DO+FgPZQFwHv4wrWi1fS/WahE7IWQBsCI6+3KVGryv8CR3V9kWgfAW2rv
UQ==
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[8.16]], CompressedData["
1:eJwBtQFK/iFib1JlAwAAABoAAAABAAAAAgAAAD4BDegb2RPAStwsfeTY97+c
3pFL0D8TwHUXrmbswfe/EgP70y6mEsBIiajh68H3v7UPTwkvCxLAMOrLpebX
/r8P4fIAcG8RwPFtuFwQp/i/HvoZ0zfTEMDXjukaMUj9v4B5/xSbORDAaRui
iQhH/b+kLkud4EEPwKU9iMh5YgDASBULkegMDsBAFlksYm8BwOu93gUU2AzA
S3mfOZJ3/r9RpY23wqYLwARlHLyBMAHABE57VAx1CsBNzMTBsLsAwHzM2vbm
QAnA2Xkmg26bAMCfmWtzAygIwP5EkqaHkwDAsImn70LeBsDlUxA8kwYAwIjl
N4bzhwXAPlWfLKSDAcC2NczWpW8EwNbobzQrigHALHKE+o9FA8BTxmmQMfEB
wPn/gB8aEgLAONbXmowmAsBghSCHqOAAwMQ14jg1tALAHladfIlT/7/yEHQV
xL8CwPrQsWr/6fy/R1eeESBfA8AhAJxsun/6vzNuZBbOwwPALD5kNnoQ+L93
flU2mmIEwMgcUR2yqfW/e7yo/VAhBcCf9LJA00nzv4Ll8qjnngXA2R/RJw==

         "]]}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
